<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;

class NewStatsController extends Controller
{

    public function index($site,$journal)
    {
        $urls =  [
            "viewsdownloads"     => route('ojs.journal.views.downloads',['site' => $site,'journal' => $journal]),
            "lastYears"          => route('ojs.journal.last.years',['site' => $site,'journal' => $journal]),
            "countriesViews"     => route('ojs.journal.countries.views',['site' => $site,'journal' => $journal]) ,
            "countriesDownloads" => route('ojs.journal.countries.downloads',['site' => $site,'journal' => $journal]),
            "articlesDownloads"  => route('ojs.journal.articles.downloads',['site' => $site,'journal' => $journal]),
            "articlesViews"      => route('ojs.journal.articles.views',['site' => $site,'journal' => $journal]) ,
            "downlodasDetail"    => route('ojs.journal.dowmloads.detail',['site' => $site,'journal' => $journal]),
            "numbers"            => route('ojs.journal.numbers',['site' => $site,'journal' => $journal]) ,
            "years"              => route('ojs.journal.years',['site' => $site,'journal' => $journal])
            ];

        return view("index")
        ->with('site',$site)
        ->with('journal',$journal)
        ->with('urls',$urls);

    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function newGeneralStats($site,$journal,$language)
    {

        $current_year = date("Y");
        $urls =  [
            "viewsdownloads"     => route('ojs.journal.views.downloads',['site' => $site,'journal' => $journal]),
            "lastYears"          => route('ojs.journal.last.years',['site' => $site,'journal' => $journal]),
            "countriesViews"     => route('ojs.journal.countries.views',['site' => $site,'journal' => $journal]) ,
            "countriesDownloads" => route('ojs.journal.countries.downloads',['site' => $site,'journal' => $journal]),
            "articlesDownloads"  => route('ojs.journal.articles.downloads',['site' => $site,'journal' => $journal]),
            "articlesViews"      => route('ojs.journal.articles.views',['site' => $site,'journal' => $journal]) ,
            "downlodasDetail"    => route('ojs.journal.dowmloads.detail',['site' => $site,'journal' => $journal]),
            "numbers"            => route('ojs.journal.numbers',['site' => $site,'journal' => $journal]) ,
            "years"              => route('ojs.journal.years',['site' => $site,'journal' => $journal])
            ];
     

        return view("new_general_stats")
        ->with('site',$site)
        ->with('journal',$journal)
        ->with('urls',$urls)
        ->with('language',$language)
        ->with('current_year',$current_year);

    }

    public function viewsDownloads($site,$journal)
    {   

         $q = Input::get('q');
        if($q == null){
            $q = date("Y");
         }
        $months = \DB::connection($site)->select('SELECT  case SUBSTR(month,5,6)
                                             when 01 then "Enero"
                                             when 02 then "Febrero"
                                             when 03 then "Marzo"
                                             when 04 then "Abril"
                                             when 05 then "Mayo"
                                             when 06 then "Junio"
                                             when 07 then "Julio"
                                             when 08 then "Agosto"
                                             when 09 then "Septiembre"
                                             when 10 then "Octubre"
                                             when 11 then "Noviembre"
                                             when 12 then "Diciembre"
                                             end AS Mes,
                                            Sum(case when metrics.assoc_type in(1048585) then metrics.metric end) as Visitas,
                                            Sum(case when metrics.assoc_type in(515) then metrics.metric end) as Descargas,
                                            year as Anno
                                            FROM metrics
                                            WHERE context_id = ? 
                                            and metrics.year = ?
                                            and month is not null
                                            GROUP BY Mes, Anno
                                            order by SUBSTR(month,5,6) ASC', [$journal,$q]);

    return $months;
    }


    public function lastYears($site,$journal)
    {
        $q = Input::get('q');

        
        if($q == null or $q == 0){
            
            $variable =  "is not null";

         } else {

            $variable =  "<= ?";
         }

        $total = \DB::connection($site)->select('SELECT
                                                        Sum(case when metrics.assoc_type in(1048585) then metrics.metric end) as Visitas,
                                                        Sum(case when metrics.assoc_type in(515) then metrics.metric end) as Descargas,
                                                        year AS Anno
                                                        FROM metrics
                                                        WHERE context_id = ? 
                                                        and year '.$variable.'  
                                                        and month is not null
                                                        GROUP BY Anno
                                                        order by Anno ASC', [$journal,$q]);
        return $total;
    }



    public function countriesViews($site,$journal)
    {
         $q = Input::get('q');
        if($q == null){
            $q = date("Y");
         }
        $total = \DB::connection($site)->select('SELECT country_id as id,
                                                    SUM(metric) as Visitas,
                                                    city as Nombre,
                                                    metrics.year as Anno
                                                    FROM metrics 
                                                    WHERE context_id=?
                                                    AND assoc_type=1048585 and country_id is not null
                                                    and metrics.year = ? 
                                                    GROUP BY id , Anno
                                                    order by SUM(metric) desc ', [$journal,$q]);

    return $total;
    }

    public function countriesDownloads($site,$journal)
    {
         $q = Input::get('q');
        if($q == null){
            $q = date("Y");
         }
        $total = \DB::connection($site)->select('SELECT country_id as id,
                                                    SUM(metric) as Descargas,
                                                    city as Nombre,
                                                    year as Anno
                                                    FROM metrics 
                                                    WHERE context_id=?
                                                    AND assoc_type=515 and country_id is not null
                                                    and year = ? 
                                                    GROUP BY id, year 
                                                    order by SUM(metric) desc  ', [$journal,$q]);

    return $total;
    }


    public function articlesDownloads($site,$journal)
    {
        $q = Input::get('q');
        if($q == null){
            $q = date("Y");
        }

         $journalName = $this->retriveJournalName($site,$journal);

        $url = $this->retriveUrl($site);

        $downloads = \DB::connection($site)->select('SELECT
                                    submission_settings.setting_value as Articulo,
                                    SUM(metrics.metric) as Descargas,
                                    CONCAT("'.$url.'/index.php/'.$journalName[0]->path.'/article/view/",submission_settings.submission_id) as Link,
                                    metrics.year as Anno
                                    FROM metrics 
                                    INNER JOIN submission_settings ON metrics.submission_id = submission_settings.submission_id 
                                    WHERE metrics.context_id = ?
                                    AND metrics.assoc_type = 515  
                                    AND submission_settings.setting_name = "title"   
                                    AND submission_settings.locale = "es_ES" 
                                    AND metrics.year = ?
                                    GROUP BY metrics.assoc_id, Anno
                                    order by SUM(metrics.metric) DESC LIMIT 20', [$journal,$q]);
           return $downloads;
    }

    

    public function articlesViews($site,$journal)
    {
        $q = Input::get('q');
        
        if($q == null){
            $q = date("Y");
        }

        $journalName = $this->retriveJournalName($site,$journal);

        $url = $this->retriveUrl($site);

        $downloads = \DB::connection($site)->select('SELECT 
                                    submission_settings.setting_value as Articulo,
                                     SUM(metrics.metric) as Visitas,
                                     CONCAT("'.$url.'/index.php/'.$journalName[0]->path.'/article/view/",submission_settings.submission_id) as Link,
                                     metrics.year as Anno
                                    FROM metrics
                                    INNER JOIN submission_settings ON metrics.submission_id = submission_settings.submission_id 
                                    WHERE metrics.context_id = ? 
                                    AND metrics.assoc_type = 1048585 
                                    AND metrics.year = ?
                                    AND submission_settings.setting_name = "title"   
                                    AND submission_settings.locale = "es_ES" 
                                    GROUP BY metrics.assoc_id, Anno order by SUM(metrics.metric) DESC LIMIT 20;', [$journal,$q]);
        return $downloads;
    }



   /* public function downloadsDetail($site,$journal)
    {
        
        $q = Input::get('q');
        if($q == null){
            $q = date("Y");
         }

        $file_type = $this->retriveFileType($site);


        if(count($file_type) == 1){

        $total = \DB::connection($site)->select('SELECT CONCAT(SUBSTR(month,1,4) ," - " , SUBSTR(month,5,6) ) AS Mes,
                                                        sum(case when metrics.assoc_type in(515) and metrics.file_type in(1) then metrics.metric end) as HTML, 
                                                        sum(case when metrics.assoc_type in(515) and metrics.file_type in(2) then metrics.metric end) as PDF,
                                                        sum(case when metrics.assoc_type in(515) and metrics.file_type in(3) then metrics.metric end) as "'.$file_type[0].'",
                                                        year as Anno
                                                        from metrics
                                                        where year = ? 
                                                        and metrics.month is not null 
                                                        and metrics.context_id=?
                                                        GROUP BY Mes , Anno
                                                        ORDER BY Mes Asc ', [$q,$journal]);

    } else {

        $columns = $this->retriveString($file_type); 

        
        $total = \DB::connection($site)->select('SELECT CONCAT(SUBSTR(month,1,4) ," - " , SUBSTR(month,5,6) ) AS Mes,
                                                        sum(case when metrics.assoc_type in(515) and metrics.file_type in(1) then metrics.metric end) as HTML, 
                                                        sum(case when metrics.assoc_type in(515) and metrics.file_type in(2) then metrics.metric end) as PDF,
                                                        '.$columns.'
                                                        year as Anno
                                                        from metrics
                                                        where year = ? 
                                                        and metrics.month is not null 
                                                        and metrics.context_id=?
                                                        GROUP BY Mes , Anno
                                                        ORDER BY Mes Asc ', [$q,$journal]);



            }
            return $total;
        }
    
    public function retriveString($array)
    {
        $string = null;

        for ($i=0; $i < count($array) ; $i++) { 
                $j = $i+3;
            $string = $string .''.'sum(case when metrics.assoc_type in(515) and metrics.file_type in('.$j.') then metrics.metric end) as '.$array[$i].' , ';
        }

        return $string;
        
    }*/

    public function downloadsDetail($site,$journal)
    {
        
        $q = Input::get('q');
        if($q == null){
            $q = date("Y");
         }

        // $file_type = $this->retriveFileType($site);


        $total = \DB::connection($site)->select('SELECT CONCAT(SUBSTR(month,1,4) ," - " , SUBSTR(month,5,6) ) AS Mes,
                                                        sum(case when metrics.assoc_type in(515) and metrics.file_type in(1) then metrics.metric end) as HTML, 
                                                        sum(case when metrics.assoc_type in(515) and metrics.file_type in(2) then metrics.metric end) as PDF,
                                                        year as Anno
                                                        from metrics
                                                        where year = ? 
                                                        and metrics.month is not null 
                                                        and metrics.context_id=?
                                                        GROUP BY Mes , Anno
                                                        ORDER BY Mes Asc ', [$q,$journal]);
       return $total;
    }


    public function numbers($site,$journal)
    {
         $q = Input::get('q');
        if($q == null){
            $q = date("Y");
        }


        $journalName = $this->retriveJournalName($site,$journal);

        $url = $this->retriveUrl($site);


        $downloads = \DB::connection($site)->select('SELECT issues.volume as Volumen,
                                    issues.number as Numero,
                                    issues.year as Anno,
                                    issue_settings.setting_value as Titulo,
                                    CONCAT(" Vol " , issues.volume , " ", " Num " , issues.number, " " , " Año " , issues.year) as Resumen,
                                    SUM(metrics.metric) as Visitas,
                                    CONCAT("'.$url.'/index.php/'.$journalName[0]->path.'/issue/view/",issues.issue_id) as Link,
                                    metrics.year as MAnno
                                     FROM metrics
                                    LEFT JOIN issues on metrics.assoc_id = issues.issue_id 
                                    LEFT JOIN issue_settings  on issues.issue_id= issue_settings.issue_id 
                                    WHERE metrics.context_id = ? 
                                    AND metrics.assoc_type = 259 
                                    AND metrics.year = ?
                                    AND issue_settings.setting_name = "title" 
                                    AND issue_settings.locale = "es_ES"
                                    AND issues.published = 1
                                    GROUP BY issue_settings.issue_id, MAnno 
                                    ORDER BY SUM(metrics.metric) DESC LIMIT 20;', [$journal,$q]);
     return $downloads;
    }



    public function years($site,$journal)
    {
         $years = \DB::connection($site)->select('SELECT year from metrics where year is not null and year != 0 group by year');
           return $years;
    }



    public function retriveUrl($site)
    {
        $url = null;
        switch($site) {
        case 'unisucre': 
                $url = 'https://revistas.unisucre.edu.co';
                    break;
        case 'uexternado': 
                $url = 'https://revistas.uexternado.edu.co';        
        break;
        case 'asoneumocito': 
                $url = 'https://revistas.asoneumocito.org';        
        break;
        case 'ean': 
                $url = 'https://journal.universidadean.edu.co';        
        break;
        case 'ibero': 
                $url = 'https://revistas.iberoamericana.edu.co';        
        break;
        case 'eia': 
                $url = 'https://revistas.eia.edu.co';        
        break;
        case 'uptc': 
                $url = 'https://revistas.uptc.edu.co';        
        break;
        case 'corpas': 
                $url = 'https://revistas.juanncorpas.edu.co';        
        break;
        case 'ecr': 
                $url = 'https://revistas.ecr.edu.co';        
        break;
        case 'umecit': 
                $url = 'https://revistas.umecit.edu.pa';        
        break;
        case 'fucsalud': 
                $url = 'https://revistas.fucsalud.edu.co';        
        break;
        case 'udca': 
                $url = 'https://udca.metarevistas.org';        
        break;
        case 'unicolmayor': 
                $url = 'https://unicolmayor.metarevistas.org';        
        break;
        case 'escuelaing': 
                $url = 'https://escuelaing.metarevistas.org';        
        break;
        case 'itc': 
                $url = 'itc.metarevistas.org';        
        break;
        case 'accb': 
                $url = 'https://www.ojs.asociacioncolombianadecienciasbiologicas.org';        
        break;
        case 'ens': 
                $url = 'https://revistasens.metarevistas.org';        
        break;
        case 'unicordoba': 
                $url = 'https://unicordoba.metarevistas.org';        
        break;

        
    }

        return $url;
    }


    public function retriveFileType($site)
    {

        
        $data_array = array();


        switch($site) {
        case 'unisucre': 
                array_push($data_array,"E-BOOK");
                    break;
        case 'uexternado': 
                array_push($data_array,"XML");       
        break;
        case 'ean': 
                array_push($data_array,"PDF ENGLISH");    
        break;
        case 'fucsalud': 
                array_push($data_array,"EPUB","XML");    
        break;
    }
        return $data_array;
    }


    public function retriveJournalName($site,$journal)
    {
        $journalName = \DB::connection($site)->select('select path from journals where journal_id = ?',[$journal]);

        return $journalName;
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
