<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;

class StatsController extends Controller
{

    public function index($site,$journal)
    {
        $urls =  [
            "viewsdownloads"     => route('ojs.journal.views.downloads',['site' => $site,'journal' => $journal]),
            "lastYears"          => route('ojs.journal.last.years',['site' => $site,'journal' => $journal]),
            "countriesViews"     => route('ojs.journal.countries.views',['site' => $site,'journal' => $journal]) ,
            "countriesDownloads" => route('ojs.journal.countries.downloads',['site' => $site,'journal' => $journal]),
            "articlesDownloads"  => route('ojs.journal.articles.downloads',['site' => $site,'journal' => $journal]),
            "articlesViews"      => route('ojs.journal.articles.views',['site' => $site,'journal' => $journal]) ,
            "downlodasDetail"    => route('ojs.journal.dowmloads.detail',['site' => $site,'journal' => $journal]),
            "numbers"            => route('ojs.journal.numbers',['site' => $site,'journal' => $journal]) ,
            "years"              => route('ojs.journal.years',['site' => $site,'journal' => $journal])
            ];

        return view("index")
        ->with('site',$site)
        ->with('journal',$journal)
        ->with('urls',$urls);

    }

    
    public function index2($site,$journal)
    {
        $urls =  [
            "viewsdownloads"     => route('ojs.journal.views.downloads',['site' => $site,'journal' => $journal]),
            "lastYears"          => route('ojs.journal.last.years',['site' => $site,'journal' => $journal]),
            "countriesViews"     => route('ojs.journal.countries.views',['site' => $site,'journal' => $journal]) ,
            "countriesDownloads" => route('ojs.journal.countries.downloads',['site' => $site,'journal' => $journal]),
            "articlesDownloads"  => route('ojs.journal.articles.downloads',['site' => $site,'journal' => $journal]),
            "articlesViews"      => route('ojs.journal.articles.views',['site' => $site,'journal' => $journal]) ,
            "downlodasDetail"    => route('ojs.journal.dowmloads.detail',['site' => $site,'journal' => $journal]),
            "numbers"            => route('ojs.journal.numbers',['site' => $site,'journal' => $journal]) ,
            "years"              => route('ojs.journal.years',['site' => $site,'journal' => $journal])
            ];

        return view("index2")
        ->with('site',$site)
        ->with('journal',$journal)
        ->with('urls',$urls);

    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function generalStats($site,$journal,$language)
    {

        $current_year = date("Y");
        $urls =  [
            "viewsdownloads"     => route('ojs.journal.views.downloads',['site' => $site,'journal' => $journal]),
            "lastYears"          => route('ojs.journal.last.years',['site' => $site,'journal' => $journal]),
            "countriesViews"     => route('ojs.journal.countries.views',['site' => $site,'journal' => $journal]) ,
            "countriesDownloads" => route('ojs.journal.countries.downloads',['site' => $site,'journal' => $journal]),
            "articlesDownloads"  => route('ojs.journal.articles.downloads',['site' => $site,'journal' => $journal]),
            "articlesViews"      => route('ojs.journal.articles.views',['site' => $site,'journal' => $journal]) ,
            "downlodasDetail"    => route('ojs.journal.dowmloads.detail',['site' => $site,'journal' => $journal]),
            "numbers"            => route('ojs.journal.numbers',['site' => $site,'journal' => $journal]) ,
            "years"              => route('ojs.journal.years',['site' => $site,'journal' => $journal])
            ];
     

        return view("general_stats")
        ->with('site',$site)
        ->with('journal',$journal)
        ->with('urls',$urls)
        ->with('language',$language)
        ->with('current_year',$current_year);

    }


    public function generalStatsOmp($site,$journal,$language)
    {

        
        $urls =  [
            "viewsdownloads"     => route('ojs.journal.views.downloads',['site' => $site,'journal' => $journal]),
            "lastYears"          => route('ojs.journal.last.years',['site' => $site,'journal' => $journal]),
            "countriesViews"     => route('ojs.journal.countries.views',['site' => $site,'journal' => $journal]) ,
            "countriesDownloads" => route('ojs.journal.countries.downloads',['site' => $site,'journal' => $journal]),
            "articlesDownloads"  => route('ojs.journal.articles.downloads',['site' => $site,'journal' => $journal]),
            "articlesViews"      => route('ojs.journal.articles.views',['site' => $site,'journal' => $journal]) ,
            "downlodasDetail"    => route('ojs.journal.dowmloads.detail',['site' => $site,'journal' => $journal]),
            "numbers"            => route('ojs.journal.numbers',['site' => $site,'journal' => $journal]) ,
            "years"              => route('ojs.journal.years',['site' => $site,'journal' => $journal])
            ];
     

        return view("general_stats_omp")
        ->with('site',$site)
        ->with('journal',$journal)
        ->with('urls',$urls)
        ->with('language',$language);


    }




    public function viewsDownloads($site,$journal)
    {   

         $q = Input::get('q');
        if($q == null){
            $q = date("Y");
         }

         if($site === 'acho'){
            $months = \DB::connection($site)->select('SELECT  case month(date)
                                                    when 01 then "Enero"
                                                    when 02 then "Febrero"
                                                    when 03 then "Marzo"
                                                    when 04 then "Abril"
                                                    when 05 then "Mayo"
                                                    when 06 then "Junio"
                                                    when 07 then "Julio"
                                                    when 08 then "Agosto"
                                                    when 09 then "Septiembre"
                                                    when 10 then "Octubre"
                                                    when 11 then "Noviembre"
                                                    when 12 then "Diciembre"
                                                    end AS Mes,
                                                   Sum(case when metrics_submission.assoc_type in(1048585) then metrics_submission.metric end) as Visitas,
                                                   Sum(case when metrics_submission.assoc_type in(515) then metrics_submission.metric end) as Descargas,
                                                   year(date) as Anno
                                                   FROM metrics_submission
                                                   WHERE context_id = ?
                                                   and year(metrics_submission.date) = ?
                                                   and date is not null
                                                   GROUP BY Mes, Anno
                                                   order by MONTH(date) ASC', [$journal,$q]);

         }else{

            $months = \DB::connection($site)->select('SELECT  case SUBSTR(month,5,6)
                                             when 01 then "Enero"
                                             when 02 then "Febrero"
                                             when 03 then "Marzo"
                                             when 04 then "Abril"
                                             when 05 then "Mayo"
                                             when 06 then "Junio"
                                             when 07 then "Julio"
                                             when 08 then "Agosto"
                                             when 09 then "Septiembre"
                                             when 10 then "Octubre"
                                             when 11 then "Noviembre"
                                             when 12 then "Diciembre"
                                             end AS Mes,
                                            Sum(case when metrics.assoc_type in(1048585) then metrics.metric end) as Visitas,
                                            Sum(case when metrics.assoc_type in(515) then metrics.metric end) as Descargas,
                                            year as Anno
                                            FROM metrics
                                            WHERE context_id = ? 
                                            and metrics.year = ?
                                            and month is not null
                                            GROUP BY Mes, Anno
                                            order by SUBSTR(month,5,6) ASC', [$journal,$q]);
        }

    return $months;
    }


    public function lastYears($site,$journal)
    {
        $q = Input::get('q');

        
        if($q == null or $q == 0){
            
            $variable =  "is not null";

         } else {

            $variable =  "<= ?";
         }


         if($site === 'acho'){

          $total = \DB::connection($site)->select('SELECT
                                                    Sum(case when metrics_submission.assoc_type in(1048585) then metrics_submission.metric end) as Visitas,
                                                    Sum(case when metrics_submission.assoc_type in(515) then metrics_submission.metric end) as Descargas,
                                                    year(date) AS Anno
                                                    FROM metrics_submission
                                                    WHERE context_id =  ?
                                                    and year(date) '.$variable.' 
                                                    and date is not null
                                                    GROUP BY Anno
                                                    order by Anno ASC', [$journal,$q]);
      }else{

        $total = \DB::connection($site)->select('SELECT
                                                        Sum(case when metrics.assoc_type in(1048585) then metrics.metric end) as Visitas,
                                                        Sum(case when metrics.assoc_type in(515) then metrics.metric end) as Descargas,
                                                        year AS Anno
                                                        FROM metrics
                                                        WHERE context_id = ? 
                                                        and year '.$variable.'  
                                                        and month is not null
                                                        GROUP BY Anno
                                                        order by Anno ASC', [$journal,$q]);
        }
        return $total;
    }



    public function countriesViews($site,$journal)
    {
         $q = Input::get('q');
        if($q == null){
            $q = date("Y");
         }

         if($site === 'acho'){
            $total = \DB::connection($site)->select('SELECT metrics_submission_geo_daily.country as id,
                                                    SUM(metrics_submission_geo_daily.metric) as Visitas,
                                                    metrics_submission_geo_daily.city as Nombre,
                                                    year(metrics_submission_geo_daily.date) as Anno
                                                    FROM metrics_submission_geo_daily
                                                    LEFT JOIN metrics_submission ON metrics_submission_geo_daily.submission_id = metrics_submission.submission_id
                                                    WHERE metrics_submission_geo_daily.load_id = metrics_submission.load_id 
                                                    AND metrics_submission_geo_daily.context_id= ? 
                                                    AND metrics_submission.assoc_type=1048585 
                                                    AND metrics_submission_geo_daily.country is not null
                                                    AND year(metrics_submission_geo_daily.date) = ?
                                                    GROUP BY id , Anno
                                                    order by SUM(metrics_submission_geo_daily.metric) desc', [$journal,$q]);

        }else{

        $total = \DB::connection($site)->select('SELECT country_id as id,
                                                    SUM(metric) as Visitas,
                                                    city as Nombre,
                                                    metrics.year as Anno
                                                    FROM metrics 
                                                    WHERE context_id=?
                                                    AND assoc_type=1048585 and country_id is not null
                                                    and metrics.year = ? 
                                                    GROUP BY id , Anno
                                                    order by SUM(metric) desc ', [$journal,$q]);

        }

    return $total;
    }

    public function countriesDownloads($site,$journal)
    {
         $q = Input::get('q');
        if($q == null){
            $q = date("Y");
         }


          if($site === 'acho'){
             $total = \DB::connection($site)->select('SELECT metrics_submission_geo_daily.country as id,
                                                    SUM(metrics_submission_geo_daily.metric) as Descargas,
                                                    metrics_submission_geo_daily.city as Nombre,
                                                    year(metrics_submission_geo_daily.date) as Anno
                                                    FROM metrics_submission_geo_daily
                                                    LEFT JOIN metrics_submission ON metrics_submission_geo_daily.submission_id = metrics_submission.submission_id
                                                    WHERE metrics_submission_geo_daily.load_id = metrics_submission.load_id 
                                                    AND metrics_submission_geo_daily.context_id= ? 
                                                    AND metrics_submission.assoc_type= 515   
                                                    AND metrics_submission_geo_daily.country is not null
                                                    AND year(metrics_submission_geo_daily.date) = ?
                                                    GROUP BY id , Anno
                                                    order by SUM(metrics_submission_geo_daily.metric) desc', [$journal,$q]);

        }else{

        $total = \DB::connection($site)->select('SELECT country_id as id,
                                                    SUM(metric) as Descargas,
                                                    city as Nombre,
                                                    year as Anno
                                                    FROM metrics 
                                                    WHERE context_id=?
                                                    AND assoc_type=515 and country_id is not null
                                                    and year = ? 
                                                    GROUP BY id, year 
                                                    order by SUM(metric) desc  ', [$journal,$q]);
    }

    return $total;
    }


    public function articlesDownloads($site,$journal)
    {
        $q = Input::get('q');
        if($q == null){
            $q = date("Y");
        }

         $journalName = $this->retriveJournalName($site,$journal);

        $url = $this->retriveUrl($site);


        $journalVersion = (int)$this->retriveJournalVersion($site);

        
         if($site === 'acho'){

            $downloads = \DB::connection($site)->select('SELECT
                                                    a.setting_value as Articulo,
                                                    SUM(m.metric) as Descargas,
                                                    CONCAT("'.$url.'/index.php/'.$journalName[0]->path.'/article/view/",a.submission_id) as Link,
                                                    year(m.date) as Anno
                                                    FROM metrics_submission m
                                                    INNER JOIN (
                                                    SELECT pb.setting_value, publications.submission_id, sub.context_id
                                                    FROM publications
                                                    LEFT JOIN publication_settings pb ON publications.publication_id = pb.publication_id
                                                    LEFT JOIN submissions sub ON publications.submission_id = sub.submission_id
                                                    WHERE pb.setting_name = "title"
                                                    AND pb.setting_value <> ""
                                                    AND pb.locale = "es")a ON m.submission_id = a.submission_id
                                                    WHERE
                                                    m.assoc_type = 515
                                                    AND m.context_id = ?
                                                    AND year(m.date) = ?
                                                    GROUP BY a.submission_id
                                                    order by SUM(m.metric) DESC LIMIT 20;', [$journal,$q]);
                                                       return $downloads;

        }else{

              $downloads = \DB::connection($site)->select('select 
                                a.setting_value as Articulo, 
                                SUM(m.metric) as Descargas,
                                CONCAT("'.$url.'/index.php/'.$journalName[0]->path.'/article/view/",a.submission_id) as Link,
                                m.year as Anno 
                                FROM metrics m
                                INNER JOIN (
                                    SELECT pb.setting_value, publications.submission_id, sub.context_id
                                    FROM publications
                                    LEFT JOIN publication_settings pb ON publications.publication_id = pb.publication_id
                                    LEFT JOIN submissions sub ON publications.submission_id = sub.submission_id
                                    WHERE pb.setting_name = "title" 
                                    AND pb.setting_value <> "" 
                                    AND pb.locale = "es_ES")a ON m.submission_id = a.submission_id 
                                WHERE 
                                m.assoc_type = 515 
                                AND m.context_id = ?
                                AND m.year = ? 
                                GROUP BY a.submission_id
                                order by SUM(m.metric) DESC LIMIT 20;', [$journal,$q]);
        }

           return $downloads;
    }

    

    public function articlesViews($site,$journal)
    {
        $q = Input::get('q');
        
        if($q == null){
            $q = date("Y");
        }

        $journalName = $this->retriveJournalName($site,$journal);

        $url = $this->retriveUrl($site);

        $journalVersion = $this->retriveJournalVersion($site);

        
        if($site === 'acho'){

                $downloads = \DB::connection($site)->select('select
                                                            a.setting_value as Articulo,
                                                            SUM(m.metric) as Visitas,
                                                            CONCAT("'.$url.'/index.php/'.$journalName[0]->path.'/article/view/",a.submission_id) as Link,
                                                            year(m.date) as Anno
                                                            FROM metrics_submission m
                                                            INNER JOIN (
                                                            SELECT pb.setting_value, publications.submission_id, sub.context_id
                                                            FROM publications
                                                            LEFT JOIN publication_settings pb ON publications.publication_id = pb.publication_id
                                                            LEFT JOIN submissions sub ON publications.submission_id = sub.submission_id
                                                            WHERE pb.setting_name = "title"
                                                            AND pb.setting_value <> ""
                                                            AND pb.locale = "es")a ON m.submission_id = a.submission_id
                                                            WHERE
                                                            m.assoc_type = 1048585
                                                            AND m.context_id = ?
                                                            AND year(m.date) = ?
                                                            GROUP BY a.submission_id
                                                            order by SUM(m.metric) DESC LIMIT 20;', [$journal,$q]);
                                                            return $downloads;




        }else{
              $downloads = \DB::connection($site)->select('select 
                                                                a.setting_value as Articulo, 
                                                                SUM(m.metric) as Visitas,
                                                                CONCAT("'.$url.'/index.php/'.$journalName[0]->path.'/article/view/",a.submission_id) as Link,
                                                                m.year as Anno 
                                                                FROM metrics m
                                                                INNER JOIN (
                                                                        SELECT pb.setting_value, publications.submission_id, sub.context_id
                                                                        FROM publications
                                                                        LEFT JOIN publication_settings pb ON publications.publication_id = pb.publication_id
                                                                        LEFT JOIN submissions sub ON publications.submission_id = sub.submission_id
                                                                        WHERE pb.setting_name = "title" 
                                    AND pb.setting_value <> "" 
                                    AND pb.locale = "es_ES")a ON m.submission_id = a.submission_id
                                                                WHERE 
                                                                m.assoc_type = 1048585 
                                                                AND m.context_id = ?
                                                                AND m.year = ? 
                                                                GROUP BY a.submission_id
                                                                order by SUM(m.metric) DESC LIMIT 20;', [$journal,$q]);

        }
        return $downloads;
    }



   

    public function downloadsDetail($site,$journal)
    {
        
        $q = Input::get('q');
        if($q == null){
            $q = date("Y");
         }

        // $file_type = $this->retriveFileType($site);


            if($site === 'acho' ){

                $total = \DB::connection($site)->select('SELECT CONCAT(year(metrics_submission.date) ," - " , MONTH(metrics_submission.date)) AS Mes,
                                                        sum(case when metrics_submission.assoc_type in(515) and metrics_submission.file_type in(1) then metrics_submission.metric end) as HTML,
                                                        sum(case when metrics_submission.assoc_type in(515) and metrics_submission.file_type in(2) then metrics_submission.metric end) as PDF,
                                                        year(metrics_submission.date) as Anno
                                                        from metrics_submission
                                                        where year(metrics_submission.date) = ?
                                                        and metrics_submission.date is not null
                                                        and metrics_submission.context_id= ?
                                                        GROUP BY Mes , Anno
                                                        ORDER BY Mes Asc ', [$q,$journal]);

            }else{

        $total = \DB::connection($site)->select('SELECT CONCAT(SUBSTR(month,1,4) ," - " , SUBSTR(month,5,6) ) AS Mes,
                                                        sum(case when metrics.assoc_type in(515) and metrics.file_type in(1) then metrics.metric end) as HTML, 
                                                        sum(case when metrics.assoc_type in(515) and metrics.file_type in(2) then metrics.metric end) as PDF,
                                                        year as Anno
                                                        from metrics
                                                        where year = ? 
                                                        and metrics.month is not null 
                                                        and metrics.context_id=?
                                                        GROUP BY Mes , Anno
                                                        ORDER BY Mes Asc ', [$q,$journal]);
       
        }

       return $total;
    }


    public function numbers($site,$journal)
    {
         $q = Input::get('q');
        if($q == null){
            $q = date("Y");
        }


                $journalName = $this->retriveJournalName($site,$journal);

                $url = $this->retriveUrl($site);


                if($site === 'acho'){

                      $downloads = \DB::connection($site)->select('SELECT issues.volume as Volumen,
                                                                issues.number as Numero,
                                                                issues.year as Anno,
                                                                case
                                                                when issue_settings.setting_value = ""
                                                                then CONCAT(" Vol " , issues.volume , " ", " Num " , issues.number, " " , " Año " , issues.year)
                                                                else issue_settings.setting_value
                                                                end as Titulo,
                                                                CONCAT(" Vol " , issues.volume , " ", " Num " , issues.number, " " , " Año " , issues.year) as Resumen,
                                                                SUM(metrics_issue.metric) as Visitas,
                                                                CONCAT("'.$url.'/index.php/'.$journalName[0]->path.'/issue/view/",issues.issue_id) as Link,
                                                                year(metrics_issue.date) as MAnno
                                                                 FROM metrics_issue
                                                                 LEFT JOIN issues on metrics_issue.issue_id = issues.issue_id
                                                                LEFT JOIN issue_settings  on issues.issue_id= issue_settings.issue_id
                                                                WHERE metrics_issue.context_id = ?
                                                                AND year(metrics_issue.date) = ?
                                                                AND issue_settings.setting_name = "title"
                                                                AND issue_settings.locale = "es"
                                                                AND issues.published = 1
                                                                GROUP BY issue_settings.issue_id, MAnno
                                                                ORDER BY SUM(metrics_issue.metric) DESC LIMIT 20;', [$journal,$q]);
                }else {



              $downloads = \DB::connection($site)->select('select issues.volume as Volumen,
                                                            issues.number as Numero,
                                                            issues.year as Anno,
                                                            case
                                                            when issue_settings.setting_value = ""
                                                            then CONCAT(" Vol " , issues.volume , " ", " Num " , issues.number, " " , " Año " , issues.year)
                                                            else issue_settings.setting_value
                                                            end as Titulo,
                                                            CONCAT(" Vol " , issues.volume , " ", " Num " , issues.number, " " , " Año " , issues.year) as Resumen,
                                                            SUM(metrics.metric) as Visitas,
                                                            CONCAT("'.$url.'/index.php/'.$journalName[0]->path.'/issue/view/",issues.issue_id) as Link,
                                                            metrics.year as MAnno
                                                             FROM metrics
                                                             LEFT JOIN issues on metrics.assoc_id = issues.issue_id 
                                                            LEFT JOIN issue_settings  on issues.issue_id= issue_settings.issue_id 
                                                            WHERE metrics.context_id = ? 
                                                            AND metrics.assoc_type = 259 
                                                            AND metrics.year = ?
                                                            AND issue_settings.setting_name = "title" 
                                                            AND issue_settings.locale = "es_ES"
                                                            AND issues.published = 1
                                                            GROUP BY issue_settings.issue_id, MAnno 
                                                            ORDER BY SUM(metrics.metric) DESC LIMIT 20;', [$journal,$q]);
              }

             return $downloads;
    }



    public function years($site,$journal)
    {
         if($site === 'acho'){
            $years = \DB::connection($site)->select('SELECT year from metrics_submission where year is not null and year != 0 group by year');
        }else{ 
            $years = \DB::connection($site)->select('SELECT year from metrics where year is not null and year != 0 group by year');
        }
           return $years;
    }



    public function retriveUrl($site)
    {
        $url = null;
        switch($site) {
        case 'value': 
                $url = 'https://revistas.unisucre.edu.co';
        break;

        case 'caldas':
                $url = 'https://revistasojs.ucaldas.edu.co';
        break;
        case 'ojudicial':
                $url = 'https://revistasapientia.organojudicial.gob.pa';
        break;
        case 'acho':
                $url = 'https://revista.acho.info';
        break;
        case 'ucatolica':
                $url = 'https://editorial.ucatolica.edu.co';
        break;  
        case 'qlu':
                $url = 'https://revistas.qlu.ac.pa';
        break;  

    

    }

        return $url;
    }


    public function retriveFileType($site)
    {

        
        $data_array = array();


        switch($site) {
        case 'unisucre': 
                array_push($data_array,"E-BOOK");
                    break;
        case 'uexternado': 
                array_push($data_array,"XML");       
        break;
        case 'ean': 
                array_push($data_array,"PDF ENGLISH");    
        break;
        case 'fucsalud': 
                array_push($data_array,"EPUB","XML");    
        break;
    }
        return $data_array;
    }


    public function retriveJournalName($site,$journal)
    {
        $journalName = \DB::connection($site)->select('select path from journals where journal_id = ?',[$journal]);

        return $journalName;
    }

    public function retriveJournalVersion($site)
    {
        $journalVersion = \DB::connection($site)->select('select concat(major,minor,revision,build) FROM versions WHERE product IN ("ojs2") AND current=1;');

        return $journalVersion;
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
