<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;

class googleController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */


    public function descargas()
    {
      return view('download');  
    }

     public function ultimos()
    {
      return view('ultimosAnnos');  
    }

    public function tipo()
    {
      return view('tipoDescarga');  
    }

     public function visitas()
    {
      return view('views');  
    }
    public function sitio()
    {
      return view('visitasDescargasSitio');  
    }

    public function volumen()
    {
        return view('volumen');
    }

    public function vPais()
    {
        return view('visitasPais');
    }

    public function dPais()
    {
        return view('descargasPais');
    }


    public function ajaxList()
    {
        $total = \DB::select('SELECT name as Nombre, user_type_id as Tipo, count(*) as Cantidad  FROM external_users where user_type_id = 1 or user_type_id = 2 or user_type_id = 3 group by Tipo, Nombre');

    return $total;
        //dd($total);
    }


    public function tipoDescarga()
    {

        $q = Input::get('q');
        if($q == null){
            $q = date("Y");
         }
        $total = \DB::connection('unisucre')->select('SELECT CONCAT(SUBSTR(month,1,4) ," - " , SUBSTR(month,5,6) ) AS Mes,
                                                        sum(case when metrics.assoc_type in(515) and metrics.file_type in(1) then metrics.metric end) as Html, 
                                                        sum(case when metrics.assoc_type in(515) and metrics.file_type in(2) then metrics.metric end) as PDF,
                                                        year as Anno
                                                        from metrics
                                                        where year = ? 
                                                        and metrics.month is not null 
                                                        and metrics.context_id=1 
                                                        GROUP BY Mes , Anno
                                                        ORDER BY Mes Asc ', [$q]);
    return $total;
       
    }


    public function ultimosAnnos()
    {

        $q = Input::get('q');

        
        if($q == null or $q == 0){
            
            $variable =  "is not null";

         } else {

            $variable =  "<= ?";
         }

        $total = \DB::connection('unisucre')->select('SELECT
                                                        Sum(case when metrics.assoc_type in(1048585) then metrics.metric end) as Visitas,
                                                        Sum(case when metrics.assoc_type in(515) then metrics.metric end) as Descargas,
                                                        year AS Anno
                                                        FROM metrics
                                                        WHERE context_id = 1 
                                                        and year '.$variable.'  
                                                        and month is not null
                                                        GROUP BY Anno
                                                        order by SUBSTR(month,5,6) ASC', [$q]);
    return $total;
       
    }


    public function visitasPais()
    {

        $q = Input::get('q');
        if($q == null){
            $q = date("Y");
         }
        $total = \DB::connection('unisucre')->select('SELECT country_id as Pais,
                                                    SUM(metric) as Visitas,
                                                    city as Nombre,
                                                    metrics.year as Anno
                                                    FROM metrics 
                                                    WHERE context_id=1
                                                    AND assoc_type=1048585 and country_id is not null
                                                    and metrics.year = ? 
                                                    GROUP BY Pais , Anno
                                                    order by SUM(metric) ASC ', [$q]);

    return $total;
       
    }


    public function descargasPais()
    {

        $q = Input::get('q');
        if($q == null){
            $q = date("Y");
         }
        $total = \DB::connection('unisucre')->select('SELECT country_id as Pais,
                                                    SUM(metric) as Descargas,
                                                    city as Nombre,
                                                    year as Anno
                                                    FROM metrics 
                                                    WHERE context_id=1
                                                    AND assoc_type=515 and country_id is not null
                                                    and year = ? 
                                                    GROUP BY Pais, Anno 
                                                    order by SUM(metric) ASC  ', [$q]);

    return $total;
       
    }


     public function vydDelSitio()
    {


        $q = Input::get('q');
        if($q == null){
            $q = date("Y");
         }
        $total = \DB::connection('unisucre')->select('SELECT  case SUBSTR(month,5,6)
                                             when 01 then "Enero"
                                             when 02 then "Febrero"
                                             when 03 then "Marzo"
                                             when 04 then "Abril"
                                             when 05 then "Mayo"
                                             when 06 then "Junio"
                                             when 07 then "Julio"
                                             when 08 then "Agosto"
                                             when 09 then "Septiembre"
                                             when 10 then "Octubre"
                                             when 11 then "Noviembre"
                                             when 12 then "Diciembre"
                                             end AS Mes,
                                            Sum(case when metrics.assoc_type in(1048585) then metrics.metric end) as Visitas,
                                            Sum(case when metrics.assoc_type in(515) then metrics.metric end) as Descargas,
                                            year as Anno
                                            FROM metrics
                                            WHERE context_id = 1 
                                            and metrics.year = ?
                                            and month is not null
                                            GROUP BY Mes, Anno
                                            order by SUBSTR(month,5,6) ASC', [$q]);

    return $total;
       
    }


    public function descargasPorMes()
    {

        $q = Input::get('q');
        if($q == null){
            $q = date("Y");
        }
        $downloads = \DB::connection('unisucre')->select('SELECT
                                    submission_settings.setting_value as Articulo,
                                    SUM(metrics.metric) as Descargas,
                                    metrics.year as Anno
                                    FROM metrics 
                                    INNER JOIN submission_settings ON metrics.submission_id = submission_settings.submission_id 
                                    WHERE metrics.context_id = 1
                                    AND metrics.assoc_type = 515  
                                    AND submission_settings.setting_name = "title"   
                                    AND submission_settings.locale = "es_ES" 
                                    AND metrics.year = ?
                                    GROUP BY metrics.assoc_id, Anno
                                    order by SUM(metrics.metric) DESC LIMIT 20', [$q]);
           return $downloads;
    }


    public function visitasPorMes()
    {

        $q = Input::get('q');
        if($q == null){
            $q = date("Y");
        }
        $downloads = \DB::connection('unisucre')->select('SELECT 
                                    submission_settings.setting_value as Articulo,
                                     SUM(metrics.metric) as Visitas,
                                     metrics.year as Anno
                                    FROM metrics
                                    INNER JOIN submission_settings ON metrics.submission_id = submission_settings.submission_id 
                                    WHERE metrics.context_id = 1 
                                    AND metrics.assoc_type = 1048585 
                                    AND metrics.year = ?
                                    AND submission_settings.setting_name = "title"   
                                    AND submission_settings.locale = "es_ES" 
                                    GROUP BY metrics.assoc_id, Anno order by SUM(metrics.metric) DESC LIMIT 20;', [$q]);
        return $downloads;
    }



    public function visitasPorVolumen()
    {
         $q = Input::get('q');
        if($q == null){
            $q = date("Y");
        }
        $downloads = \DB::connection('unisucre')->select('SELECT issues.volume as Volumen,
                                    issues.number as Numero,
                                    issues.year as Anno,
                                    issue_settings.setting_value as Titulo,
                                    CONCAT(" Vol " , issues.volume , " ", " Num " , issues.number, " " , " Año " , issues.year) as Resumen,
                                    SUM(metrics.metric) as Visitas,
                                    metrics.year as MAnno
                                     FROM metrics
                                    LEFT JOIN issues on metrics.assoc_id = issues.issue_id 
                                    LEFT JOIN issue_settings  on issues.issue_id= issue_settings.issue_id 
                                    WHERE metrics.context_id = 1 
                                    AND metrics.assoc_type = 259 
                                    AND metrics.year = ?
                                    AND issue_settings.setting_name = "title" 
                                    AND issue_settings.locale = "es_ES"
                                    AND issues.published = 1
                                    GROUP BY issue_settings.issue_id, MAnno 
                                    ORDER BY SUM(metrics.metric) DESC LIMIT 20;', [$q]);
     return $downloads;
    }





    public function Year()
    {
        $years = \DB::connection('unisucre')->select('SELECT year from metrics where year is not null group by year');
           return $years;
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
