<script type="text/javascript" src="https://www.google.com/jsapi"></script>
<script
  src="https://code.jquery.com/jquery-2.2.4.min.js"
  integrity="sha256-BbhdlvQf/xTY9gja0Dq3HiwQF8LaCRTXxZKRutelT44="
  crossorigin="anonymous"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/2.0.2/TweenMax.min.js"></script>


<script src="https://code.highcharts.com/highcharts.js"></script>
<script src="https://code.highcharts.com/highcharts-3d.js"></script>
<script src="https://code.highcharts.com/modules/exporting.js"></script>
<script src="https://code.highcharts.com/modules/export-data.js"></script>



<main id="dashboard_chart">

<div class='select-ctr'>
  <div class='selected-input input-preview'>Selecciona un año</div>
  <div class='input input-1' data-val='2013'>2013</div>
  <div class='input input-2' data-val='2014'>2014</div>
  <div class='input input-3' data-val='2015'>2015</div>
  <div class='input input-4' data-val='2016'>2016</div>
  <div class='input input-5' data-val='2017'>2017</div>
</div>

      <div hidden="hidden" class="dropdown" id="filter_chart"></div>
        <select style="display: none;" id="dropdown">

        </select>
    </div>





  <h5>Visitas y descargas</h5>
  <div id="bar-chart"></div>
</main>

<div id="container" style="height: 400px"></div>


<style type="text/css">
    
@import url(https://fonts.googleapis.com/css?family=Roboto:400,300);

#container {
    height: 400px; 
    min-width: 310px; 
    max-width: 800px;
    margin: 0 auto;
}

body {
  font-family: "Roboto";
  background: #EDEDED;
}
main {
  width: 50%;
  margin: 10px auto;
  padding: 10px 20px 30px;
  background: #FFF;
  box-shadow: 0 3px 5px rgba(0,0,0,0.2);
  position: relative;
}
p {
  margin-top: 2rem;
  font-size: 13px;
}
h5 {
    font-weight: 300;
    font-size: 25px;
    margin-bottom: 0;
    margin-top: 75px;  
}
#bar-chart {
  width: 100%;
  height: 300px;
  position: relative;
}
#line-chart {
  width: 500px;
  height: 300px;
  position: relative;
}
#bar-chart::before, #line-chart::before {
  content: "";
  position: absolute;
  display: block;
  width: 240px;
  height: 30px;
  left: 155px;
  top: 254px;
  background: #FFFFFF;
  /*box-shadow: 1px 1px 0 0 #DDD;*/
}
#pie-chart {
  width: 500px;
  height: 250px;
  position: relative;
}
#pie-chart::before {
  content: "";
  position: absolute;
  display: block;
  width: 120px;
  height: 115px;
  left: 315px;
  top: 0;
  background: #FAFAFA;
  box-shadow: 1px 1px 0 0 #DDD;
}
#pie-chart::after {
  content: "";
  position: absolute;
  display: block;
  top: 260px;
  left: 70px;
  width: 170px;
  height: 2px;
  background: rgba(0,0,0,0.1);
  border-radius: 50%;
  box-shadow: 0 0 3px 4px rgba(0,0,0,0.1);
}

/*SELECT*/


.select-ctr {
  z-index: 100;
  position: absolute;
  -webkit-transform: translate(-50%, -50%);
  -moz-transform: translate(-50%, -50%);
  -ms-transform: translate(-50%, -50%);
  -o-transform: translate(-50%, -50%);
  transform: translate(-50%, -50%);
  width: 350px;
  height: 370px;
  font-family: "Roboto";
  top: 45%;
  left: 65%;
}
.select-ctr > div {
  padding: 15px 20px;
  position: absolute;
  width: 100%;
  font-size: 1.25rem;
  cursor: pointer;
}
.select-ctr .input-5 {
  top: 300px;
}
.select-ctr .input-4 {
  top: 240px;
}
.select-ctr .input-3 {
  top: 180px;
}
.select-ctr .input-2 {
  top: 120px;
}
.select-ctr .input-1 {
  top: 60px;
}
.select-ctr > div.input {
  background: #fff;
  color: #777;
  border-radius: 2px;
  box-shadow: 0 2px 15px 3px rgba(0, 0, 0, 0.1);
}
.select-ctr > div.input.active {
  color: pink;
}
.select-ctr > div.input-preview {
  color: rgba(0, 0, 0, 0.75);
  position: relative;
  transition: .3s all ease;
  border-radius: 2px;
  box-shadow: 0 2px 15px 3px rgba(0, 0, 0, 0.1);
}
.select-ctr > div.input-preview.active {
  color: #000;
}
.select-ctr > div.input-preview:before {
  content: "";
  position: absolute;
  top: 18px;
  right: 20px;
  bottom: 20px;
  width: 20px;
  background: rgba(0, 0, 0, 0.75);
  -webkit-clip-path: polygon(50% 73%, 0 0, 100% 0);
  clip-path: polygon(50% 73%, 0 0, 100% 0);
  padding: 10px;
  box-sizing: border-box;
  transition: .3s all ease;
}
.select-ctr > div.input-preview.active:before {
  background: #000;
  -webkit-clip-path: polygon(50% 0, 0 73%, 100% 73%);
  clip-path: polygon(50% 0, 0 73%, 100% 73%);
}

</style>

<script type="text/javascript">


function getParameterByName(name, url) {
    if (!url) url = window.location.href;
    name = name.replace(/[\[\]]/g, '\\$&');
    var regex = new RegExp('[?&]' + name + '(=([^&#]*)|&|#|$)'),
        results = regex.exec(url);
    if (!results) return null;
    if (!results[2]) return '';
    return decodeURIComponent(results[2].replace(/\+/g, ' '));
}


function setParameterByName() {
    var index = url.indexOf("?q=");
    if (index>=0) {  
        url = url.substring(0, index);
    }
    url = url + "?q=" + param;
drawCharts();
  console.log(url);
}

$('#dropdown').on('change', function() {
     param = this.value;

      setParameterByName();
      //vydSitio();
    
     
  });



function cargarSitio() { 

    $.ajax({
        async: false,
        type: 'GET',
        url: url,
        success: function(data) {
          sitios = data;
        },//end success
    })
}


function cargarAnnos() { 

    $.ajax({
        async: false,
        type: 'GET',
        url:'https://revistas.unisucre.edu.co/googlecharts/public/index.php/google/unisucre/years',
        success: function(data) {
          annos = data;
        },//end success
    })

    .done(function() {
     //Load options in dropdown
        $.each(annos, function( index, value ) {
        
          $("#dropdown").append("<option value="+value.year+" >"+value.year+"</option>");
        });

  })

}

cargarAnnos();


url = 'https://revistas.unisucre.edu.co/googlecharts/public/index.php/google/unisucre/vydSitio';
sitios = null;
cargarSitio();



console.log(sitios);

google.load("visualization", "1", {packages:["corechart","controls"]});
google.setOnLoadCallback(drawCharts);
function drawCharts() {
  
  // BEGIN BAR CHART
  // actual bar chart data

  var barData = new google.visualization.DataTable();
    barData.addColumn('string', 'Mes');
    barData.addColumn('number', 'Visitas');
    barData.addColumn('number', 'Descargas');
    barData.addColumn('number', 'Anno');


    $.each(sitios, function( index, value ) {
        barData.addRows([
           [String(value.Mes), Number(value.Visitas), Number(value.Descargas), Number(value.Anno)]
        ]);

        });

    // create dashboard
    var dashboard = new google.visualization.Dashboard(document.getElementById('dashboard_chart'));

    var query = getParameterByName('q', url);

    // filter dropdown
    var categoryYear = new google.visualization.ControlWrapper({
          'controlType': 'CategoryFilter',
          'containerId': 'filter_chart',
          'options': {
            'filterColumnLabel': 'Anno',
            'ui': {
                'labelStacking': 'vertical',
                'allowTyping': false,
                'allowMultiple': false,
                'allowNone': false
            }
        },
        'state': {
            selectedValues: [query]
          }
        });

        var Chart = new google.visualization.ChartWrapper({
            'chartType': 'ColumnChart',
            'containerId': 'bar-chart',
            'view': {
                'columns': [0,1,2]
            },

            options: {
        focusTarget: 'category',
        backgroundColor: 'transparent',
        colors: ['cornflowerblue', 'tomato'],
        fontName: 'Roboto',
         is3D: true,
        //colors:[{color:'#C26900', darker:'#B15800'}, {color:'#165C04', darker:'#054B00'}],
        colors: ['#70a1ff', '#5352ed',],

        /*chartArea: {
          left: 50,
          top: 10,
          width: '100%',
          height: '70%'
        },
        bar: {
          groupWidth: '80%'
        },*/
        hAxis: {
          textStyle: {
            fontSize: 11
          }
        },
        vAxis: {
          minValue: 0,
          maxValue: 1500,
          baselineColor: '#DDD',
          gridlines: {
            color: '#DDD',
            count: 4
          },
          textStyle: {
            fontSize: 11
          }
        },
        legend: {
          position: 'bottom',
          textStyle: {
            fontSize: 12
          }
        },
        animation: {
          duration: 1200,
          easing: 'out',
                startup: true
        },
       
 
        }

    });

        dashboard.bind(categoryYear, Chart); 
        

       dashboard.draw(barData);

    //var barChart = new google.visualization.ChartWrapper(document.getElementById('bar-chart'));

    //dashboard.bind(categoryYear, barChart);
    //dashboard.draw(barData);
  
  // draw bar chart twice so it animates
    //var barChart = new google.visualization.ColumnChart(document.getElementById('bar-chart')); 
    //barChart.draw(barData, barOptions);
  
  //end bar chart
}// end draw charts

$(window).resize(function(){
  drawCharts();
});

$(document).ready(function() {

  var inputPreview = $(".input-preview"),
      input = $(".input");

  TweenMax.set(input, {
    scale: 1.2,
    alpha: 0
  });

  inputPreview.on("click", function(){
    
    var that = $(this);
    
    that.toggleClass("active");
    
    if(that.hasClass("active")){
      
      TweenMax.staggerTo(input, 1.25, {
        scale: 1,
        alpha: 1,
        ease: Elastic.easeOut
      }, .1);   
    }
    else {
      TweenMax.staggerTo(input, 1, {
        scale: 1.2,
        alpha: 0,
        ease: Elastic.easeOut
      }, .1);
    }
  });

  input.on("click", function() {

    var tlInput = new TimelineMax({
      onComplete: done
    });

    var that = $(this),
      siblings = that.siblings(".input"),
      data = that.data("val"),
      top = that.css("top");

    siblings.removeClass("active");

    tlInput.to(siblings, .25, {
        alpha: 0
      })
      .to(that, .25, {
        scale: 1.2
      })
      .to(that, .25, {
        top: 0,
      })
      .set(inputPreview, {
        display: "none"
      })
      .to(that, .25, {
        scale: 1,
      })
      .to(that, .5, {
        backgroundColor: "#DDD"
      })
      .set(inputPreview, {
        text: data,
        display: "block"
      })
      .to(that, .25, {
        alpha: 0
      })
    
    function done() {
      inputPreview.removeClass("active");
      that.css("top", top).addClass("active");

      TweenMax.set(input, {
        scale: 1.2,
        alpha: 0,
        backgroundColor: "#fff"
      });
    }

  });



Highcharts.chart('container', {
  chart: {
    type: 'column',
    options3d: {
      enabled: true,
      alpha: 10,
      beta: 25,
      depth: 70
    },
    style: {
        fontFamily: 'Roboto'
    }
 
  },
  title: {
    text: 'Visitas y descargas'
  },
  /*subtitle: {
    text: 'Notice the difference between a 0 value and a null point'
  },*/
  plotOptions: {
    column: {
      depth: 25
    }
  },
  xAxis: {
    categories: Highcharts.getOptions().lang.shortMonths,
    labels: {
      skew3d: true,
      style: {
        fontSize: '16px'
      }
    }
  },
  yAxis: {
    title: {
      text: null
    }
  },
  series: [
  {
    name: 'Sales',
    data: [2, 3, null, 4, 0, 5, 1, 4, 6, 3]
  },
    {
    name: 'Soles',
    data: [4, 10, 1, null, null, 5, 1, 4, 6, 3]
  }
  ]
});
  
});//end document ready
</script>