function ajaxData(urlStats) { 
 var dataStats = null;
 $.ajax({
    async: false,
    type: 'GET',
    url: urlStats,
    success: function(data) {
     dataStats = data;

    },
    //end success
  });
return dataStats;

}

function loadYears() {
   years = ajaxData(urls.years);

   $.each(years, function( index, value ) {
          $("#viewsAndDownloads").append("<option value="+value.year+" >"+value.year+"</option>");
          $("#lastYearSelect").append("<option value="+value.year+" >"+value.year+"</option>");
          $("#countriesSelect").append("<option value="+value.year+" >"+value.year+"</option>");
          $("#articlesSelect").append("<option value="+value.year+" >"+value.year+"</option>");
          $("#viewsSelect").append("<option value="+value.year+" >"+value.year+"</option>");
          $("#detailsSelect").append("<option value="+value.year+" >"+value.year+"</option>");
          $("#numbersSelect").append("<option value="+value.year+" >"+value.year+"</option>");

   });

  

}


function reloadYears() {

  current_year = new Date().getFullYear();

  $("#lastYearSelect").empty();
  $("#lastYearSelect").append("<option value="+current_year+" >Seleccione un período</option>");
  $("#countriesSelect").empty();
  $("#countriesSelect").append("<option value="+current_year+">Seleccione un período</option>");
  $("#articlesSelect").empty();
  $("#articlesSelect").append("<option value="+current_year+" >Seleccione un período</option>");
  $("#viewsSelect").empty();
  $("#viewsSelect").append("<option value="+current_year+" >Seleccione un período</option>");
  $("#detailsSelect").empty();
  $("#detailsSelect").append("<option value="+current_year+" >Seleccione un período</option>");
  $("#numbersSelect").empty();
  $("#numbersSelect").append("<option value="+current_year+" >Seleccione un período</option>");

  years = ajaxData(urls.years);

   $.each(years, function( index, value ) {
          $("#lastYearSelect").append("<option value="+value.year+" >"+value.year+"</option>");
          $("#countriesSelect").append("<option value="+value.year+" >"+value.year+"</option>");
          $("#articlesSelect").append("<option value="+value.year+" >"+value.year+"</option>");
          $("#viewsSelect").append("<option value="+value.year+" >"+value.year+"</option>");
          $("#detailsSelect").append("<option value="+value.year+" >"+value.year+"</option>");
          $("#numbersSelect").append("<option value="+value.year+" >"+value.year+"</option>");

   });
}


function printCssYears() {
  $('select').each(function(){
    var $this = $(this), numberOfOptions = $(this).children('option').length;
    
    $this.addClass('select-hidden'); 
    $this.wrap('<div class="select"></div>');
    $this.after('<div class="select-styled"  data-select="'+$this.attr('id')+'"></div>');

    var $styledSelect = $this.next('div.select-styled');
    $styledSelect.text($this.children('option').eq(0).text());
  
    var $list = $('<ul />', {
        'class': 'select-options'
    }).insertAfter($styledSelect);
  
    for (var i = 0; i < numberOfOptions; i++) {
        $('<li />', {
            text: $this.children('option').eq(i).text(),
            rel: $this.children('option').eq(i).val()
        }).appendTo($list);
    }
  
    var $listItems = $list.children('li');
  
    $styledSelect.click(function(e) {
        e.stopPropagation();
        $('div.select-styled.active').not(this).each(function(){
            $(this).removeClass('active').next('ul.select-options').hide();
        });
        $(this).toggleClass('active').next('ul.select-options').toggle();
    });
  
    $listItems.click(function(e) {
        e.stopPropagation();
        $styledSelect.text($(this).text()).removeClass('active');
        $this.val($(this).attr('rel'));
        $list.hide();
    });
  
    $(document).click(function() {
        $styledSelect.removeClass('active');
        $list.hide();
    });

});
}


function setParameterByName(id , url ,urlTwo) {

    urlTest = url;
    urlTestTwo = urlTwo;

    var index = urlTest.indexOf("?q=");
   
    if (index >= 0) {  
        urlTest = urlTest.substring(0, index);
    }
    urlTest = urlTest + "?q=" + param;



    // when set params in countries maps 
    if(urlTwo != null){
       var indexTwo = urlTestTwo.indexOf("?q=");
      if (indexTwo >= 0) {  
          urlTestTwo = urlTestTwo.substring(0, indexTwo);
      }
        urlTestTwo = urlTestTwo + "?q=" + param;
    }


     switch (id) { 
          case 'viewsAndDownloads': 
            loadViewsDownloads(urlTest);
            break;
          case 'lastYearSelect': 
            loadLastYear(urlTest);
            break;
          case 'countriesSelect': 
            loadCountriesMaps(urlTest,urlTestTwo);
            break;    
          case 'articlesSelect': 
            loadArticlesDownloads(urlTest);
            break;
            case 'viewsSelect': 
            loadArticlesViews(urlTest);
            break;
            case 'detailsSelect': 
            loadDetails(urlTest);
            break;
            case 'numbersSelect': 
            loadNumbers(urlTest);
            break;
}

}


function loadViewsDownloads(urlParam) {
 
  viewsDownloads = ajaxData(urlParam);

  visitas =retriveData("Visitas", viewsDownloads);
  visitas = visitas.map( Number );

  descargas = retriveData("Descargas", viewsDownloads)
  descargas = descargas.map(Number);


  printStatViewsDownloads();

}

function loadLastYear(urlParam) {
  lastYear = ajaxData(urlParam);

  visitasLastYear =retriveData("Visitas", lastYear);
  visitasLastYear = visitasLastYear.map(Number);

  descargasLastYear = retriveData("Descargas", lastYear)
  descargasLastYear = descargasLastYear.map(Number);

  printStatLastYear();

}

function loadArticlesDownloads(urlParam) {
    articlesDownloads = ajaxData(urlParam);
    downloads = retriveData("Descargas",articlesDownloads);
    downloads = downloads.map(Number);
    arrayDownloads = [["", 0]];

    arrayDownloads.length = 0 ;

    for (var i = 0; i < articlesDownloads.length; i++) {
          var array1 = [articlesDownloads[i].Articulo,downloads[i]];
          arrayDownloads.push(array1);

}

  if($('#containerArticlesDownloads').is(':empty')){
        
        
        var globalTable = $('#tableDownloads').dataTable({
        // ... skipped other options ...
        "ajax": {
           "url": urlParam,
           "dataSrc": ""
        },
        "columns": [
          {
            "data": "Articulo",
            render: function ( data, type, full ) {
                return '<a style="color:#000000;" href="'+full.Link+'" target="_blank">'+data+'</a>';
              },// end render
            "orderable": true,
           },
          {"data": "Descargas"},
        ],
        "language": {

          "processing":     "Cargando datos...",
          "search":         "Buscar:",
          "lengthMenu":     "Mostrar _MENU_ registros",
          "info":           "Mostrando registros del <strong> _START_ al _END_ </strong> de <strong> _TOTAL_ </strong> registros",
          "infoEmpty":      "Mostrando registros del 0 al 0 de un total de 0 registros",
          "infoFiltered":   "(filtrado de un total de _MAX_ registros)",
          "infoPostFix":    "",
          "loadingRecords": "Cargando...",
          "zeroRecords":    "No se encontraron resultados",
          "emptyTable":     "Ningún dato disponible",
          "paginate": {
                    first:      "Primero",
                    previous:   "Anterior ",
                    next:       " Siguiente",
                    last:       "Último"
                },

            },
        "bAutoWidth":       false,
        "bDeferRender":     true,
        "bLengthChange":    true,
        "order": [[ 1, "desc" ]],
        });
    } else { 
      var data = articlesDownloads;
            
    globalTable = $('#tableDownloads').DataTable();

    globalTable.clear();

    globalTable.rows.add(data).draw();

    }



printArticlesDownloads();

}



function loadArticlesViews(urlParam) {
  articlesViews = ajaxData(urlParam);
  views = retriveData("Visitas",articlesViews);
  views = views.map(Number);
  arrayViews = [["", 0]];

  arrayViews.length = 0 ;

  for (var i = 0; i < articlesViews.length; i++) {
        var array2 = [articlesViews[i].Articulo,views[i]];
        arrayViews.push(array2);

  }

  if($('#containerArticlesViews').is(':empty')){
        
        var globalTable = $('#tableViews').dataTable({
        // ... skipped other options ...
        "ajax": {
           "url": urlParam,
           "dataSrc": ""
        },
        "columns": [
              {
            "data": "Articulo",
            render: function ( data, type, full ) {
                return '<a style="color:#000000;" href="'+full.Link+'" target="_blank">'+data+'</a>';
              },// end render
            "orderable": true,
           },
            {"data": "Visitas"},
        ],
        "language": {

          "processing":     "Cargando datos...",
          "search":         "Buscar:",
          "lengthMenu":     "Mostrar _MENU_ registros",
          "info":           "Mostrando registros del <strong> _START_ al _END_ </strong> de <strong> _TOTAL_ </strong> registros",
          "infoEmpty":      "Mostrando registros del 0 al 0 de un total de 0 registros",
          "infoFiltered":   "(filtrado de un total de _MAX_ registros)",
          "infoPostFix":    "",
          "loadingRecords": "Cargando...",
          "zeroRecords":    "No se encontraron resultados",
          "emptyTable":     "Ningún dato disponible",
          "paginate": {
                    first:      "Primero",
                    previous:   "Anterior ",
                    next:       " Siguiente",
                    last:       "Último"
                },

            },
        "bAutoWidth":       false,
        "bDeferRender":     true,
        "bLengthChange":    true,
        "order": [[ 1, "desc" ]],
        });
    } else { 
      var data = articlesViews;
            
    globalTable = $('#tableViews').DataTable();

    globalTable.clear();

    globalTable.rows.add(data).draw();

    }

  printArticlesViews();
}


function loadDetails(urlParam) {
  
 downloadsDetail = ajaxData(urlParam);

html = retriveData("HTML", downloadsDetail);
html = html.map( Number );

pdf = retriveData("PDF", downloadsDetail);
pdf = pdf.map( Number );

// three columns 
if(Object.keys(downloadsDetail[0]).length > 4){

    arrayFiles =[];
    var value = null;

  for (var i = 3; i < downloadsDetail.length; i++) {

      fileType = Object.keys(downloadsDetail[0])[i];
      value = retriveData(fileType ,downloadsDetail);
      value = value.map( Number );

      item = {}
        item ["name"] = fileType;
        item ["data"] = value;
        item ["color"] = '#ff3838';

      arrayFiles.push(item);

      //jsonTest = JSON.stringify(arrayFiles);

       /*$.each($jsonFiles, function(i, value) {
       result += ","+ $jsonFiles[i];
      });​*/

  }

      result= null;
      $.each(arrayFiles, function( i, item ) {
        
        

        //result = result + "," + arrayFiles[i];
        result =  item + ',';

     });

      

printDownloadsDetailType();

} else{
  
    printDownloadsDetail();

    }
}


function loadCountries(urlParamViews, urlParamDownloads) {



     countriesViews = ajaxData(urlParamViews);
     countriesDownloads = ajaxData (urlParamDownloads);


     countriesViews =  retriveCountries(countriesViews);
     countriesDownloads = retriveCountries(countriesDownloads);


     views = retriveData("Visitas",countriesViews);
     downloads = retriveData("Descargas",countriesDownloads);

     arrayViews = [["", 0]];
     arrayViews.length = 0 ;

     arrayDownloads = [["", 0]];
     arrayDownloads.length = 0;

     //Load new array for chart with views in correct format 
     for (var i = 0; i < countriesViews.length; i++) {
          var array4 = [countriesViews[i].Nombre,views[i]];
          arrayViews.push(array4);

    }
      //Load new array for chart with views in correct format
     for (var i = 0; i < countriesDownloads.length; i++) {
          var array5 = [countriesDownloads[i].Nombre,downloads[i]];
          arrayDownloads.push(array5);

    }


     printCountriesViews(arrayViews);
     printCountriesDownloads(arrayDownloads);

}

function loadCountriesMaps(urlParamViews, urlParamDownloads) {



     countriesViews = ajaxData(urlParamViews);
     countriesDownloads = ajaxData (urlParamDownloads);


     countriesViews =  retriveCountries(countriesViews);
     countriesDownloads = retriveCountries(countriesDownloads);

     $('#containerViews').empty();
     $('#containerDownloads').empty();


     printCountriesViewsMaps(countriesViews);
     printCountriesDownloadsMaps(countriesDownloads);


    
}



function loadNumbers(urlParam) {

  globalTable = null;

    numbers = ajaxData(urlParam);
    viewsNumber = retriveData("Visitas",numbers);
    viewsNumber = viewsNumber.map(Number);
    arrayViewsNumber = [["", 0]];

    arrayViewsNumber.length = 0 ;

    for (var i = 0; i < numbers.length; i++) {
          var array3 = [numbers[i].Resumen,viewsNumber[i]];
          arrayViewsNumber.push(array3);

    }



if($('#containerNumbers').is(':empty')){
        
        var globalTable = $('#tableNumbers').dataTable({
        // ... skipped other options ...
        
        "ajax": {
           "url": urlParam,
           "dataSrc": ""
        },
        "columns": [
            {"data": "Volumen"},
            {"data": "Numero"},
            {"data": "Anno"},
            {
            "data": "Titulo",
            render: function ( data, type, full ) {
                return '<a style="color:#000000;" href="'+full.Link+'" target="_blank">'+data+'</a>';
              },// end render
            "orderable": true,
           },
            {"data": "Visitas"},
        ],
        "language": {

          "processing":     "Cargando datos...",
          "search":         "Buscar:",
          "lengthMenu":     "Mostrar _MENU_ registros",
          "info":           "Mostrando registros del <strong> _START_ al _END_ </strong> de <strong> _TOTAL_ </strong> registros",
          "infoEmpty":      "Mostrando registros del 0 al 0 de un total de 0 registros",
          "infoFiltered":   "(filtrado de un total de _MAX_ registros)",
          "infoPostFix":    "",
          "loadingRecords": "Cargando...",
          "zeroRecords":    "No se encontraron resultados",
          "emptyTable":     "Ningún dato disponible",
          "paginate": {
                    first:      "Primero",
                    previous:   "Anterior ",
                    next:       " Siguiente",
                    last:       "Último"
                },

            },
        "bAutoWidth":       false,
        "bDeferRender":     true,
        "bLengthChange":    true,
        "order": [[ 4, "desc" ]],
        });
    } else { 
      var data = numbers;
            
    globalTable = $('#tableNumbers').DataTable();

    globalTable.clear();

    globalTable.rows.add(data).draw();


    //globalTable.columns.adjust().draw();
    }

printNumbers();

}


function retriveCountries(array) {
  

  countries = [ 
{"name": "Afghanistan", "code": "AF"}, 
{"name": "land Islands", "code": "AX"}, 
{"name": "Albania", "code": "AL"}, 
{"name": "Algeria", "code": "DZ"}, 
{"name": "American Samoa", "code": "AS"}, 
{"name": "AndorrA", "code": "AD"}, 
{"name": "Angola", "code": "AO"}, 
{"name": "Anguilla", "code": "AI"}, 
{"name": "Antarctica", "code": "AQ"}, 
{"name": "Antigua and Barbuda", "code": "AG"}, 
{"name": "Argentina", "code": "AR"}, 
{"name": "Armenia", "code": "AM"}, 
{"name": "Aruba", "code": "AW"}, 
{"name": "Australia", "code": "AU"}, 
{"name": "Austria", "code": "AT"}, 
{"name": "Azerbaijan", "code": "AZ"}, 
{"name": "Bahamas", "code": "BS"}, 
{"name": "Bahrain", "code": "BH"}, 
{"name": "Bangladesh", "code": "BD"}, 
{"name": "Barbados", "code": "BB"}, 
{"name": "Belarus", "code": "BY"}, 
{"name": "Belgium", "code": "BE"}, 
{"name": "Belize", "code": "BZ"}, 
{"name": "Benin", "code": "BJ"}, 
{"name": "Bermuda", "code": "BM"}, 
{"name": "Bhutan", "code": "BT"}, 
{"name": "Bolivia", "code": "BO"}, 
{"name": "Bosnia and Herzegovina", "code": "BA"}, 
{"name": "Botswana", "code": "BW"}, 
{"name": "Bouvet Island", "code": "BV"}, 
{"name": "Brazil", "code": "BR"}, 
{"name": "British Indian Ocean Territory", "code": "IO"}, 
{"name": "Brunei Darussalam", "code": "BN"}, 
{"name": "Bulgaria", "code": "BG"}, 
{"name": "Burkina Faso", "code": "BF"}, 
{"name": "Burundi", "code": "BI"}, 
{"name": "Cambodia", "code": "KH"}, 
{"name": "Cameroon", "code": "CM"}, 
{"name": "Canada", "code": "CA"}, 
{"name": "Cape Verde", "code": "CV"}, 
{"name": "Cayman Islands", "code": "KY"}, 
{"name": "Central African Republic", "code": "CF"}, 
{"name": "Chad", "code": "TD"}, 
{"name": "Chile", "code": "CL"}, 
{"name": "China", "code": "CN"}, 
{"name": "Christmas Island", "code": "CX"}, 
{"name": "Cocos (Keeling) Islands", "code": "CC"}, 
{"name": "Colombia", "code": "CO"}, 
{"name": "Comoros", "code": "KM"}, 
{"name": "Congo", "code": "CG"}, 
{"name": "Congo, The Democratic Republic of the", "code": "CD"}, 
{"name": "Cook Islands", "code": "CK"}, 
{"name": "Costa Rica", "code": "CR"}, 
{"name": "Cote D"+"Ivoire", "code": "CI"}, 
{"name": "Croatia", "code": "HR"}, 
{"name": "Cuba", "code": "CU"}, 
{"name": "Cyprus", "code": "CY"}, 
{"name": "Czech Republic", "code": "CZ"}, 
{"name": "Denmark", "code": "DK"}, 
{"name": "Djibouti", "code": "DJ"}, 
{"name": "Dominica", "code": "DM"}, 
{"name": "Dominican Republic", "code": "DO"}, 
{"name": "Ecuador", "code": "EC"}, 
{"name": "Egypt", "code": "EG"}, 
{"name": "El Salvador", "code": "SV"}, 
{"name": "Equatorial Guinea", "code": "GQ"}, 
{"name": "Eritrea", "code": "ER"}, 
{"name": "Estonia", "code": "EE"}, 
{"name": "Ethiopia", "code": "ET"}, 
{"name": "Falkland Islands (Malvinas)", "code": "FK"}, 
{"name": "Faroe Islands", "code": "FO"}, 
{"name": "Fiji", "code": "FJ"}, 
{"name": "Finland", "code": "FI"}, 
{"name": "France", "code": "FR"}, 
{"name": "French Guiana", "code": "GF"}, 
{"name": "French Polynesia", "code": "PF"}, 
{"name": "French Southern Territories", "code": "TF"}, 
{"name": "Gabon", "code": "GA"}, 
{"name": "Gambia", "code": "GM"}, 
{"name": "Georgia", "code": "GE"}, 
{"name": "Germany", "code": "DE"}, 
{"name": "Ghana", "code": "GH"}, 
{"name": "Gibraltar", "code": "GI"}, 
{"name": "Greece", "code": "GR"}, 
{"name": "Greenland", "code": "GL"}, 
{"name": "Grenada", "code": "GD"}, 
{"name": "Guadeloupe", "code": "GP"}, 
{"name": "Guam", "code": "GU"}, 
{"name": "Guatemala", "code": "GT"}, 
{"name": "Guernsey", "code": "GG"}, 
{"name": "Guinea", "code": "GN"}, 
{"name": "Guinea-Bissau", "code": "GW"}, 
{"name": "Guyana", "code": "GY"}, 
{"name": "Haiti", "code": "HT"}, 
{"name": "Heard Island and Mcdonald Islands", "code": "HM"}, 
{"name": "Holy See (Vatican City State)", "code": "VA"}, 
{"name": "Honduras", "code": "HN"}, 
{"name": "Hong Kong", "code": "HK"}, 
{"name": "Hungary", "code": "HU"}, 
{"name": "Iceland", "code": "IS"}, 
{"name": "India", "code": "IN"}, 
{"name": "Indonesia", "code": "ID"}, 
{"name": "Iran, Islamic Republic Of", "code": "IR"}, 
{"name": "Iraq", "code": "IQ"}, 
{"name": "Ireland", "code": "IE"}, 
{"name": "Isle of Man", "code": "IM"}, 
{"name": "Israel", "code": "IL"}, 
{"name": "Italy", "code": "IT"}, 
{"name": "Jamaica", "code": "JM"}, 
{"name": "Japan", "code": "JP"}, 
{"name": "Jersey", "code": "JE"}, 
{"name": "Jordan", "code": "JO"}, 
{"name": "Kazakhstan", "code": "KZ"}, 
{"name": "Kenya", "code": "KE"}, 
{"name": "Kiribati", "code": "KI"}, 
{"name": "Korea, Democratic People"+"S Republic of", "code": "KP"}, 
{"name": "Korea, Republic of", "code": "KR"}, 
{"name": "Kuwait", "code": "KW"}, 
{"name": "Kyrgyzstan", "code": "KG"}, 
{"name": "Lao People"+"S Democratic Republic", "code": "LA"}, 
{"name": "Latvia", "code": "LV"}, 
{"name": "Lebanon", "code": "LB"}, 
{"name": "Lesotho", "code": "LS"}, 
{"name": "Liberia", "code": "LR"}, 
{"name": "Libyan Arab Jamahiriya", "code": "LY"}, 
{"name": "Liechtenstein", "code": "LI"}, 
{"name": "Lithuania", "code": "LT"}, 
{"name": "Luxembourg", "code": "LU"}, 
{"name": "Macao", "code": "MO"}, 
{"name": "Macedonia, The Former Yugoslav Republic of", "code": "MK"}, 
{"name": "Madagascar", "code": "MG"}, 
{"name": "Malawi", "code": "MW"}, 
{"name": "Malaysia", "code": "MY"}, 
{"name": "Maldives", "code": "MV"}, 
{"name": "Mali", "code": "ML"}, 
{"name": "Malta", "code": "MT"}, 
{"name": "Marshall Islands", "code": "MH"}, 
{"name": "Martinique", "code": "MQ"}, 
{"name": "Mauritania", "code": "MR"}, 
{"name": "Mauritius", "code": "MU"}, 
{"name": "Mayotte", "code": "YT"}, 
{"name": "Mexico", "code": "MX"}, 
{"name": "Micronesia, Federated States of", "code": "FM"}, 
{"name": "Moldova, Republic of", "code": "MD"}, 
{"name": "Monaco", "code": "MC"}, 
{"name": "Mongolia", "code": "MN"}, 
{"name": "Montenegro", "code": "ME"},
{"name": "Montserrat", "code": "MS"},
{"name": "Morocco", "code": "MA"}, 
{"name": "Mozambique", "code": "MZ"}, 
{"name": "Myanmar", "code": "MM"}, 
{"name": "Namibia", "code": "NA"}, 
{"name": "Nauru", "code": "NR"}, 
{"name": "Nepal", "code": "NP"}, 
{"name": "Netherlands", "code": "NL"}, 
{"name": "Netherlands Antilles", "code": "AN"}, 
{"name": "New Caledonia", "code": "NC"}, 
{"name": "New Zealand", "code": "NZ"}, 
{"name": "Nicaragua", "code": "NI"}, 
{"name": "Niger", "code": "NE"}, 
{"name": "Nigeria", "code": "NG"}, 
{"name": "Niue", "code": "NU"}, 
{"name": "Norfolk Island", "code": "NF"}, 
{"name": "Northern Mariana Islands", "code": "MP"}, 
{"name": "Norway", "code": "NO"}, 
{"name": "Oman", "code": "OM"}, 
{"name": "Pakistan", "code": "PK"}, 
{"name": "Palau", "code": "PW"}, 
{"name": "Palestinian Territory, Occupied", "code": "PS"}, 
{"name": "Panama", "code": "PA"}, 
{"name": "Papua New Guinea", "code": "PG"}, 
{"name": "Paraguay", "code": "PY"}, 
{"name": "Peru", "code": "PE"}, 
{"name": "Philippines", "code": "PH"}, 
{"name": "Pitcairn", "code": "PN"}, 
{"name": "Poland", "code": "PL"}, 
{"name": "Portugal", "code": "PT"}, 
{"name": "Puerto Rico", "code": "PR"}, 
{"name": "Qatar", "code": "QA"}, 
{"name": "Reunion", "code": "RE"}, 
{"name": "Romania", "code": "RO"}, 
{"name": "Russian Federation", "code": "RU"}, 
{"name": "RWANDA", "code": "RW"}, 
{"name": "Saint Helena", "code": "SH"}, 
{"name": "Saint Kitts and Nevis", "code": "KN"}, 
{"name": "Saint Lucia", "code": "LC"}, 
{"name": "Saint Pierre and Miquelon", "code": "PM"}, 
{"name": "Saint Vincent and the Grenadines", "code": "VC"}, 
{"name": "Samoa", "code": "WS"}, 
{"name": "San Marino", "code": "SM"}, 
{"name": "Sao Tome and Principe", "code": "ST"}, 
{"name": "Saudi Arabia", "code": "SA"}, 
{"name": "Senegal", "code": "SN"}, 
{"name": "Serbia", "code": "RS"}, 
{"name": "Seychelles", "code": "SC"}, 
{"name": "Sierra Leone", "code": "SL"}, 
{"name": "Singapore", "code": "SG"}, 
{"name": "Slovakia", "code": "SK"}, 
{"name": "Slovenia", "code": "SI"}, 
{"name": "Solomon Islands", "code": "SB"}, 
{"name": "Somalia", "code": "SO"}, 
{"name": "South Africa", "code": "ZA"}, 
{"name": "South Georgia and the South Sandwich Islands", "code": "GS"}, 
{"name": "Spain", "code": "ES"}, 
{"name": "Sri Lanka", "code": "LK"}, 
{"name": "Sudan", "code": "SD"}, 
{"name": "Suriname", "code": "SR"}, 
{"name": "Svalbard and Jan Mayen", "code": "SJ"}, 
{"name": "Swaziland", "code": "SZ"}, 
{"name": "Sweden", "code": "SE"}, 
{"name": "Switzerland", "code": "CH"}, 
{"name": "Syrian Arab Republic", "code": "SY"}, 
{"name": "Taiwan, Province of China", "code": "TW"}, 
{"name": "Tajikistan", "code": "TJ"}, 
{"name": "Tanzania, United Republic of", "code": "TZ"}, 
{"name": "Thailand", "code": "TH"}, 
{"name": "Timor-Leste", "code": "TL"}, 
{"name": "Togo", "code": "TG"}, 
{"name": "Tokelau", "code": "TK"}, 
{"name": "Tonga", "code": "TO"}, 
{"name": "Trinidad and Tobago", "code": "TT"}, 
{"name": "Tunisia", "code": "TN"}, 
{"name": "Turkey", "code": "TR"}, 
{"name": "Turkmenistan", "code": "TM"}, 
{"name": "Turks and Caicos Islands", "code": "TC"}, 
{"name": "Tuvalu", "code": "TV"}, 
{"name": "Uganda", "code": "UG"}, 
{"name": "Ukraine", "code": "UA"}, 
{"name": "United Arab Emirates", "code": "AE"}, 
{"name": "United Kingdom", "code": "GB"}, 
{"name": "United States", "code": "US"}, 
{"name": "United States Minor Outlying Islands", "code": "UM"}, 
{"name": "Uruguay", "code": "UY"}, 
{"name": "Uzbekistan", "code": "UZ"}, 
{"name": "Vanuatu", "code": "VU"}, 
{"name": "Venezuela", "code": "VE"}, 
{"name": "Viet Nam", "code": "VN"}, 
{"name": "Virgin Islands, British", "code": "VG"}, 
{"name": "Virgin Islands, U.S.", "code": "VI"}, 
{"name": "Wallis and Futuna", "code": "WF"}, 
{"name": "Western Sahara", "code": "EH"}, 
{"name": "Yemen", "code": "YE"}, 
{"name": "Zambia", "code": "ZM"}, 
{"name": "Zimbabwe", "code": "ZW"} 
];


   $.each(array, function(key, value) {
        
          for (i = 0; i < countries.length; i++) { 
              if (array[key].id == countries[i].code){
           
                  array[key].Nombre = countries[i].name;
              }
          }
      });


return array;


}



function retriveData(index,array){
var pivotArray = [];
$.each(array, function(key, value) {
  pivotArray.push(value[index]);
});

return pivotArray;

}


/*function changeDimensions(option) {
  
  loadViewsDownloads(urls.viewsdownloads,option);

  }
*/


function printStatViewsDownloads() {


  Highcharts.chart('container', {
  chart: {
    type: typeViewsDownloads,
    options3d: {
      enabled: optionViesDownloads ,
      alpha: 10,
      beta: 25,
      depth: 70
    },
    style: {
        fontFamily: 'Roboto'
    }
 
  },
  title: {
    text: 'Visitas y Descargas del Sitio'
  },
  /*subtitle: {
    text: 'Notice the difference between a 0 value and a null point'
  },*/
  plotOptions: {
    column: {
      stacking: plotViewsDownloads,
      depth: 25
    }
  },
  xAxis: {
    categories: retriveData("Mes", viewsDownloads),//Highcharts.getOptions().lang.shortMonths,
    labels: {
      skew3d: true,
      style: {
        fontSize: '16px'
      }
    }
  },
  yAxis: {
    title: {
      text: null
    }
  },
  series: [
  {
    name: 'Visitas',
    data: visitas,
    //color : '#e74c3c'
    color : '#e1b12c'
  },
    {
    name: 'Descargas',
    data: descargas,
    //color : '#A3CB38'
    color: '#00a8ff'
  }
  ]
});
}

function printStatLastYear() {
  Highcharts.chart('containerLastYear', {
  chart: {
    type: typeLastYear,
    options3d: {
      enabled: optionLastYear,
      alpha: 10,
      beta: 25,
      depth: 70
    },
    style: {
        fontFamily: 'Roboto'
    }
 
  },
  title: {
    text: 'Visitas y descargas ultimos años'
  },
  /*subtitle: {
    text: 'Notice the difference between a 0 value and a null point'
  },*/
  plotOptions: {
    column: {
      stacking: plotLastYear,
      depth: 25
    }
  },
  xAxis: {
    categories: retriveData("Anno",lastYear),//Highcharts.getOptions().lang.shortMonths,
    labels: {
      skew3d: true,
      style: {
        fontSize: '16px'
      }
    }
  },
  yAxis: {
    title: {
      text: null
    }
  },
  series: [
  {
    name: 'Visitas',
    data: visitasLastYear,
      color : '#e1b12c'
  },
    {
    name: 'Descargas',
    data: descargasLastYear,
    color: '#00a8ff'
  }
  ]
});
}

function printDownloadsDetail() {
  Highcharts.chart('containerDownloadsDetail', {
  chart: {
    type: typeDetail,
    options3d: {
      enabled: optionDetail,
      alpha: 10,
      beta: 25,
      depth: 70
    },
    style: {
        fontFamily: 'Roboto'
    }
 
  },
  title: {
    text: 'Descargas Por Tipo de Archivo'
  },
  /*subtitle: {
    text: 'Notice the difference between a 0 value and a null point'
  },*/
  plotOptions: {
    column: {
      stacking: plotDetail,
      depth: 25
    }
  },
  xAxis: {
    categories: retriveData("Mes",downloadsDetail),//Highcharts.getOptions().lang.shortMonths,
    labels: {
      skew3d: true,
      style: {
        fontSize: '16px'
      }
    }
  },
  yAxis: {
    title: {
      text: null
    }
  },
  series: [
  {
    name: 'HTML',
    data: html,
    color : '#e1b12c'



  },
    {
    name: 'PDF',
    data: pdf,
    color: '#00a8ff'

  }
  /*{
    name: 'E-BOOk',
    data: book,
    color: '#e74c3c'

  }*/
  ]
});
}


function printDownloadsDetailType() {
  Highcharts.chart('containerDownloadsDetail', {
  chart: {
    type: typeDetail,
    options3d: {
      enabled: optionDetail,
      alpha: 10,
      beta: 25,
      depth: 70
    },
    style: {
        fontFamily: 'Roboto'
    }
 
  },
  title: {
    text: 'Descargas Por Tipo de Archivo'
  },
  /*subtitle: {
    text: 'Notice the difference between a 0 value and a null point'
  },*/
  plotOptions: {
    column: {
      stacking: plotDetail,
      depth: 25
    }
  },
  xAxis: {
    categories: retriveData("Mes",downloadsDetail),//Highcharts.getOptions().lang.shortMonths,
    labels: {
      skew3d: true,
      style: {
        fontSize: '16px'
      }
    }
  },
  yAxis: {
    title: {
      text: null
    }
  },
  series: [
  {
    name: 'HTML',
    data: html,
    color : '#e1b12c'



  },
    {
    name: 'PDF',
    data: pdf,
    color: '#00a8ff'

  }
  
 
 //result
  /*{
    name: fileType,
    data: book,
    color: '#e74c3c'

  }*/
 
  ]
});
}


function printArticlesDownloads() {
  Highcharts.chart('containerArticlesDownloads', {
    chart: {
        type: 'pie',
        options3d: {
            enabled: optionDownloads,
            alpha: 45
        }
    },
    title: {
        text: 'Ranking Artículos Más Descargados'
    },
    subtitle: {
        text: 'Artículos'
    },
    plotOptions: {
        pie: {
            innerSize: 30,
            depth: 70,
            colors :  ['#0fbcf9', '#6e9f47', '#9b59b6', '#f53b57', '#ffa801']
        }
    },
    series: [{
        name: 'Descargas',
        data: arrayDownloads
    }]
});
}

function printArticlesViews() {
  Highcharts.chart('containerArticlesViews', {
    chart: {
        type: 'pie',
        options3d: {
            enabled: optionViews,
            alpha: 45
        }
    },
    title: {
        text: 'Ranking Artículos Más Visitados'
    },
    subtitle: {
        text: 'Visitas'
    },
    plotOptions: {
        pie: {
            innerSize: 30,
            depth: 70,
            colors :  ['#0fbcf9', '#6e9f47', '#9b59b6', '#f53b57', '#ffa801']
        }
    },
    series: [{
        name: 'Visitas',
        data: arrayViews
    }]
});
}


function printNumbers() {
  Highcharts.chart('containerNumbers', {
    chart: {
        type: 'pie',
        options3d: {
            enabled: optionNumber,
            alpha: 45
        }
    },
    title: {
        text: 'Visitas por Volumen'
    },
    subtitle: {
        text: 'Visitas'
    },
    plotOptions: {
        pie: {
            innerSize: 30,
            depth: 70,
            //colors:['#0fbcf9','#ff3f34','#ffa801','#00d8d6','#3c40c6','#f53b57','#0be881','#1e272e','#ffc048','#ef5777']
            colors :  ['#0fbcf9', '#6e9f47', '#9b59b6', '#f53b57', '#ffa801']
        } 
    },
    series: [{
        name: 'Visitas',
        data: arrayViewsNumber
    }]
});
}

function printCountriesViews(arrayViews) {
  

 var viewsChart =  new Chartkick.GeoChart("containerViews", arrayViews);

 var options = {
  colors: ["#1B9CFC", "#25CCF7","#2e86de"],
  label: "Visitas",

}

viewsChart.setOptions(options);

} 


function printCountriesDownloads(arrayDownloads) {

 var downloadsChart = new Chartkick.GeoChart("containerDownloads", arrayDownloads);

 var options = {
  colors: ["#58B19F", "#55E6C1","#01a3a4"],
  label: "Descargas",
}

 downloadsChart.setOptions(options);
}



function loadChanges(inputSelect) {
  
     /*param = inputSelect.value;
     id = inputSelect.id;*/

     if(inputSelect.text() == 'Seleccione un período'){

      param = new Date().getFullYear();

     } else {

      param =  inputSelect.text(); 

     }

     id = inputSelect.attr('data-select');

     var url = null;
     var url2 = null;
        switch (id) { 
          case 'viewsAndDownloads': 
            url= urls.viewsdownloads;
            break;
          case 'lastYearSelect': 
            url= urls.lastYears;
            break;
          case 'countriesSelect': 
            url = urls.countriesViews;
            url2 = urls.countriesDownloads;
            break;    
          case 'articlesSelect': 
            url= urls.articlesDownloads;
            break;
            case 'viewsSelect': 
            url= urls.articlesViews;
            break;
            case 'detailsSelect': 
            url= urls.downlodasDetail;
            break;
            case 'numbersSelect': 
            url= urls.numbers;
            break;
  }

    setParameterByName(id,url,url2);
}


function printCountriesDownloadsMaps(arrayDownloads) {


  anychart.onDocumentReady(function () {
    // The data used in this sample can be obtained from the CDN
    // https://cdn.anychart.com/samples/maps-general-features/world-choropleth-map/data.json
    
  
    anychart.data.loadJsonFile('https://cdn.anychart.com/samples/maps-general-features/world-choropleth-map/data.json', function (data) {
        var map = anychart.map();
      

        map.title()
                .enabled(true)
                .useHtml(true)
                .padding([10, 0, 10, 0])
                .text('Descargas Por País<br/>');

        map.geoData('anychart.maps.world');
        map.interactivity().selectionMode('none');
        map.padding(0);

        var dataSet = anychart.data.set(arrayDownloads);
        
       var density_data = dataSet.mapAs({'value': 'Descargas'});
       var series = map.choropleth(density_data);

        series.labels(false);

        series.hovered()
                .fill('#039be5')
                .stroke(anychart.color.darken('#039be5'));

        series.selected()
                .fill('#c2185b')
                .stroke(anychart.color.darken('#c2185b'));

        series.tooltip()
                .useHtml(true)
                .format(function () {
                    return '<span style="color: #d9d9d9">Descargas</span>: ' +
                            parseFloat(this.value).toLocaleString() + '  <br/>' +
                            '<span style="color: #d9d9d9">Año</span>: ' +
                            parseInt(this.getData('Anno')).toLocaleString() + '<br/>' + ' ';
                });

        var scale = anychart.scales.ordinalColor([
            {less: 10},
            {from: 10, to: 30},
            {from: 30, to: 50},
            {from: 50, to: 100},
            {from: 100, to: 200},
            {from: 200, to: 300},
            {from: 300, to: 500},
            {from: 500, to: 1000},
            {greater: 1000}
        ]);
       // scale.colors(['#FF7C6C', '#FF7C6C', '#FF7C6C', '#E74C3C', '#D73C2C', '#E74C3C', '#B71C0C', '#A70C00', '#870000']);
       scale.colors(['#39D5FF','#29C5FF','#19B5FE','#22A7F0','#1297E0','#0287D0','#0077C0','#0067B0','#0057A0'])
       //  scale.colors(['#ffecb3', '#ffe699', '#ffdf80', '#ffd966', '#ffd24d', '#ffcc33', '#ffc61a', '#ffbf00', '#e6ac00']);

        var colorRange = map.colorRange();
        colorRange.enabled(true)
                .padding([0, 0, 20, 0]);
        colorRange.ticks()
                .enabled(true)
                .stroke('3 #ffffff')
                .position('center')
                .length(7);
        colorRange.colorLineSize(5);
        colorRange.marker().size(7);
        colorRange.labels()
                .fontSize(11)
                .padding(3, 0, 0, 0)
                .format(function () {
                    var range = this.colorRange;
                    var name;
                    if (isFinite(range.start + range.end)) {
                        name = range.start + ' - ' + range.end;
                    } else if (isFinite(range.start)) {
                        name = 'More than ' + range.start;
                    } else {
                        name = 'Less than ' + range.end;
                    }
                    return name
                });

        series.colorScale(scale);

        // create zoom controls
        var zoomController = anychart.ui.zoom();
        zoomController.render(map);

        // set container id for the chart
        map.container('containerDownloads');
        // initiate chart drawing
        map.draw();
    });
});
}

function printCountriesViewsMaps(arrayViews) {


  anychart.onDocumentReady(function () {
    // The data used in this sample can be obtained from the CDN
    // https://cdn.anychart.com/samples/maps-general-features/world-choropleth-map/data.json
    
  
    anychart.data.loadJsonFile('https://cdn.anychart.com/samples/maps-general-features/world-choropleth-map/data.json', function (data) {
        var map = anychart.map();
      
        

        map.title()
                .enabled(true)
                .useHtml(true)
                .padding([10, 0, 10, 0])
                .text('Visitas Por País<br/>');

        map.geoData('anychart.maps.world');
        map.interactivity().selectionMode('none');
        map.padding(0);

        var dataSet = anychart.data.set(arrayViews);
        
       var density_data = dataSet.mapAs({'value': 'Visitas'});
       var series = map.choropleth(density_data);

        series.labels(false);

        series.hovered()
                .fill('#1297E0')
                .stroke(anychart.color.darken('#1297E0'));

        series.selected()
                .fill('#1297E0')
                .stroke(anychart.color.darken('#1297E0'));

        series.tooltip()
                .useHtml(true)
                .format(function () {
                    return '<span style="color: #d9d9d9">Visitas</span>: ' +
                            parseFloat(this.value).toLocaleString() + '  <br/>' +
                            '<span style="color: #d9d9d9">Año</span>: ' +
                            parseInt(this.getData('Anno')).toLocaleString() + '<br/>' + ' ';
                });

        var scale = anychart.scales.ordinalColor([
            {less: 10},
            {from: 10, to: 30},
            {from: 30, to: 50},
            {from: 50, to: 100},
            {from: 100, to: 200},
            {from: 200, to: 300},
            {from: 300, to: 500},
            {from: 500, to: 1000},
            {greater: 1000}
        ]);
        //scale.colors(['#81d4fa', '#4fc3f7', '#29b6f6', '#039be5', '#0288d1', '#0277bd', '#01579b', '#014377', '#000000']);
        // scale.colors(['#FF7C6C', '#FF7C6C', '#FF7C6C', '#E74C3C', '#D73C2C', '#E74C3C', '#B71C0C', '#A70C00', '#870000']);
        //scale.colors(['#5EFAF7', '#51F5EA', '#47EBE0', '#37DBD0', '#27CBC0', '#17BBB0', '#07ABA0', '#009B90', '#008B80']);
        //scale.colors(['#b3e6ff', '#99ddff', '#80d4ff', '#66ccff', '#4dc3ff', '#33bbff', '#1ab2ff', '#0099e6', '#00a8ff']);
        scale.colors(['#39D5FF','#29C5FF','#19B5FE','#22A7F0','#1297E0','#0287D0','#0077C0','#0067B0','#0057A0'])

        var colorRange = map.colorRange();
        colorRange.enabled(true)
                .padding([0, 0, 20, 0]);
        colorRange.ticks()
                .enabled(true)
                .stroke('3 #ffffff')
                .position('center')
                .length(7);
        colorRange.colorLineSize(5);
        colorRange.marker().size(7);
        colorRange.labels()
                .fontSize(11)
                .padding(3, 0, 0, 0)
                .format(function () {
                    var range = this.colorRange;
                    var name;
                    if (isFinite(range.start + range.end)) {
                        name = range.start + ' - ' + range.end;
                    } else if (isFinite(range.start)) {
                        name = 'More than ' + range.start;
                    } else {
                        name = 'Less than ' + range.end;
                    }
                    return name
                });

        series.colorScale(scale);

        // create zoom controls
        var zoomController = anychart.ui.zoom();
        zoomController.render(map);

        // set container id for the chart
        map.container('containerViews');
        // initiate chart drawing
        map.draw();
    });
});
}


$(document).on('change', '.select_views', function() {   
   idSwicht =  $(this).parent().attr("id");
   
 
   var url2 = null;

   optionViesDownloads = 0;

   switch (idSwicht) {
      case 'viesDownloads':
          param = $('#viewsAndDownloads').val();
          setParameterByName("viewsAndDownloads",urls.viewsdownloads,url2);
      break;
      case 'lastYear':
          param = $('#lastYearSelect').val();
          setParameterByName("lastYearSelect",urls.lastYears,url2);
      break;
      case 'views':
          param = $('#viewsSelect').val();
          setParameterByName("viewsSelect",urls.articlesViews,url2);
      break;
      case 'downloas':
          param = $('#articlesSelect').val();
          setParameterByName("articlesSelect",urls.articlesDownloads,url2);
      break;
      case 'details':
          param = $('#detailsSelect').val();
          setParameterByName("detailsSelect",urls.downlodasDetail,url2);
      break;
      case 'numbers':
          param = $('#numbersSelect').val();
          setParameterByName("numbersSelect",urls.numbers,url2);
      break;
   }
});

function AddClassSelect() {

    $('select').each(function() {
        $(this).addClass('select_views');
	      $(this).addClass('form-control');
        $(this).addClass('w-25');
        $(this).addClass('float-md-right');
    });
}

$(document).ready(function() {

    //Load select years for all tabs
    loadYears();

    // Agregar clases al select
    AddClassSelect();

    //load css to select
    // printCssYears();

  //Global Variables for change state 2D to 3D
  optionViesDownloads = 0;

  optionLastYear = 0;

  optionViews = 0;

  optionDownloads= 0;

  optionDetail = 0;

  optionNumber = 0;

  typeViewsDownloads = 'column';

  typeLastYear = 'column';

  typeDetail = 'column';  

  plotViewsDownloads = '';

  plotLastYear = '';

  plotDetail = '';
  
// Views and downloads load firts
loadViewsDownloads(urls.viewsdownloads);

  //Change funcion 
$('.select-styled').bind('DOMNodeInserted ', function() {
      loadChanges($(this));
      $('.highcharts-credits').text("");
      $('img').css("display", "none");
      $('.anychart-credits-text').css("display", "none");
});


// Click button 2D to 3D actions
$('.btn-light').click(function (e) {


      var url = null;
      var url2 = null;

      idSwicht =  $(this).parent().attr("id");



    if($(this).text().trim() == "2D"){        
      
      switch (idSwicht) { 
          case 'viesDownloadsOptions': 
                param = $('#viewsAndDownloads').val();
                optionViesDownloads = 0;
                 setParameterByName("viewsAndDownloads",urls.viewsdownloads,url2);
            break;
          case 'lastYearOptions': 
                 param = $('#lastYearSelect').val();
                 optionLastYear = 0;
                 setParameterByName("lastYearSelect",urls.lastYears,url2);
            break;   
          case 'viewOptions': 
                  param = $('#viewsSelect').val();
                 optionViews = 0;
                 setParameterByName("viewsSelect",urls.articlesViews,url2);
            break;
            case 'downloadOptions': 
                  param = $('#articlesSelect').val();
                 optionDownloads= 0;
                 setParameterByName("articlesSelect",urls.articlesDownloads,url2);
            break;
            case 'detailOptions': 
                  param = $('#detailsSelect').val();
                  optionDetail = 0;
                 setParameterByName("detailsSelect",urls.downlodasDetail,url2);
            break;
            case 'numberOptions': 
                 param = $('#numbersSelect').val();
                 optionNumber = 0;
                 setParameterByName("numbersSelect",urls.numbers,url2);
            break;
  }

    }  else if($(this).text().trim() == "3D") {


      switch (idSwicht) { 
          case 'viesDownloadsOptions': 
                param = $('#viewsAndDownloads').val();
                optionViesDownloads = 1;
                 setParameterByName("viewsAndDownloads",urls.viewsdownloads,url2);
            break;
          case 'lastYearOptions': 
                 param = $('#lastYearSelect').val();
                 optionLastYear = 1;
                 setParameterByName("lastYearSelect",urls.lastYears,url2);
            break;   
          case 'viewOptions': 
                  param = $('#viewsSelect').val();
                 optionViews = 1;
                 setParameterByName("viewsSelect",urls.articlesViews,url2);
            break;
            case 'downloadOptions': 
                  param = $('#articlesSelect').val();
                 optionDownloads= 1;
                 setParameterByName("articlesSelect",urls.articlesDownloads,url2);
            break;
            case 'detailOptions': 
                  param = $('#detailsSelect').val();
                  optionDetail = 1;
                 setParameterByName("detailsSelect",urls.downlodasDetail,url2);
            break;
            case 'numberOptions': 
                 param = $('#numbersSelect').val();
                 optionNumber = 1;
                 setParameterByName("numbersSelect",urls.numbers,url2);
            break;
  }
    } else if($(this).text().trim() == "Lineas") {

      switch (idSwicht) { 
          case 'viesDownloadsOptions': 
                typeViewsDownloads = 'spline';
                plotViewsDownloads = '';
                param = $('#viewsAndDownloads').val();
                optionViesDownloads = 0;
                 setParameterByName("viewsAndDownloads",urls.viewsdownloads,url2);
            break;
          case 'lastYearOptions': 
                typeLastYear = 'spline';
                plotLastYear = '';
                 param = $('#lastYearSelect').val();
                 optionLastYear = 0;
                 setParameterByName("lastYearSelect",urls.lastYears,url2);
            break;   
          case 'viewOptions': 
                  param = $('#viewsSelect').val();
                 optionViews = 0;
                 setParameterByName("viewsSelect",urls.articlesViews,url2);
            break;
            case 'downloadOptions': 
                  param = $('#articlesSelect').val();
                 optionDownloads= 0;
                 setParameterByName("articlesSelect",urls.articlesDownloads,url2);
            break;
            case 'detailOptions': 
                  typeDetail = 'spline';
                  plotDetail= '';
                  param = $('#detailsSelect').val();
                  optionDetail = 0;
                 setParameterByName("detailsSelect",urls.downlodasDetail,url2);
            break;
            case 'numberOptions': 
                 param = $('#numbersSelect').val();
                 optionNumber = 0;
                 setParameterByName("numbersSelect",urls.numbers,url2);
            break;
  }
    } else if($(this).text().trim() == "Columnas") {

      switch (idSwicht) { 
          case 'viesDownloadsOptions': 
                typeViewsDownloads = 'column';
                plotViewsDownloads = '';
                param = $('#viewsAndDownloads').val();
                optionViesDownloads = 0;
                 setParameterByName("viewsAndDownloads",urls.viewsdownloads,url2);
            break;
          case 'lastYearOptions': 
                 typeLastYear = 'column';
                 plotLastYear = '';
                 param = $('#lastYearSelect').val();
                 optionLastYear = 0;
                 setParameterByName("lastYearSelect",urls.lastYears,url2);
            break;   
          case 'viewOptions': 
                  param = $('#viewsSelect').val();
                 optionViews = 0;
                 setParameterByName("viewsSelect",urls.articlesViews,url2);
            break;
            case 'downloadOptions': 
                  param = $('#articlesSelect').val();
                 optionDownloads= 0;
                 setParameterByName("articlesSelect",urls.articlesDownloads,url2);
            break;
            case 'detailOptions': 
                  typeDetail = 'column';
                  plotDetail= '';
                  param = $('#detailsSelect').val();
                  optionDetail = 0;
                 setParameterByName("detailsSelect",urls.downlodasDetail,url2);
            break;
            case 'numberOptions': 
                 param = $('#numbersSelect').val();
                 optionNumber = 0;
                 setParameterByName("numbersSelect",urls.numbers,url2);
            break;
  }
    } else if($(this).text().trim() == "Columnas Apiladas") {


      switch (idSwicht) { 
          case 'viesDownloadsOptions': 
                typeViewsDownloads = 'column';
                plotViewsDownloads = 'normal';
                param = $('#viewsAndDownloads').val();
                optionViesDownloads = 0;
                 setParameterByName("viewsAndDownloads",urls.viewsdownloads,url2);
            break;
          case 'lastYearOptions': 
                 typeLastYear = 'column';
                 plotLastYear = 'normal';
                 param = $('#lastYearSelect').val();
                 optionLastYear = 0;
                 setParameterByName("lastYearSelect",urls.lastYears,url2);
            break;   
          case 'viewOptions': 
                  param = $('#viewsSelect').val();
                 optionViews = 0;
                 setParameterByName("viewsSelect",urls.articlesViews,url2);
            break;
            case 'downloadOptions': 
                  param = $('#articlesSelect').val();
                 optionDownloads= 0;
                 setParameterByName("articlesSelect",urls.articlesDownloads,url2);
            break;
            case 'detailOptions': 
                  typeDetail = 'column';
                  plotDetail= 'normal';
                  param = $('#detailsSelect').val();
                  optionDetail = 0;
                 setParameterByName("detailsSelect",urls.downlodasDetail,url2);
            break;
            case 'numberOptions': 
                 param = $('#numbersSelect').val();
                 optionNumber = 0;
                 setParameterByName("numbersSelect",urls.numbers,url2);
            break;
  }
    }
     $('.highcharts-credits').text("");
     $('img').css("display", "none");
     $('.anychart-credits-text').css("display", "none");
   
});


$('#myTab a').click(function (e) {

        e.preventDefault()  

         //Reload years 
       reloadYears();
  

       idTab = $(this).attr("id");

        switch (idTab) { 
          case 'lastYearTab': 
            // Last Year Stats
              loadLastYear(urls.lastYears);
            break;

            case 'countriesTab': 
            // countries charts
              loadCountriesMaps(urls.countriesViews,urls.countriesDownloads);
             
            break;    

            case 'articlesDownloadsTab': 
            // articles downloads
              loadArticlesDownloads(urls.articlesDownloads);
            break;

            case 'articlesViewsTab': 
            // articles Views
              loadArticlesViews(urls.articlesViews);
            break;

            case 'detailTab': 
            // downloadsDetail
              loadDetails(urls.downlodasDetail);
            break;

            case 'nummbersTab': 
            // numbers
              loadNumbers(urls.numbers);
            break;
  }
      //Remove link highcharts

      $('.highcharts-credits').text("");
      $('img').css("display", "none");

      //Remove link Anycharts
      $('.anychart-credits-text').css("display", "none");
      $('.anychart-credits-logo').css("display", "none");

});


 $('#countriesTab').on("click", function() {
    //Remove link Anycharts
      $('.anychart-credits-text').css("display", "none");
      $('.anychart-credits-logo').css("display", "none");

      $('.anychart-credits-logo').hide();
      $('.anychart-credits-text').hide();
  });

// load when change data

 /*$('select').on('change', function() {
    
    //console.log("entro");


    loadChanges(this);


 });
*/
//Delete logo hightCharts
$('.highcharts-credits').text("");

});
